/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing.junit;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.jetty.HttpConnectorFactory;
import io.dropwizard.server.ServerFactory;
import io.dropwizard.server.SimpleServerFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.DropwizardTestSupport;
import java.net.URI;
import org.junit.rules.ExternalResource;

public class DropwizardClientRule
extends ExternalResource {
    private final Object[] resources;
    private final DropwizardTestSupport<Configuration> testSupport = new DropwizardTestSupport<Configuration>(null, null, new ConfigOverride[0]){

        @Override
        public Application<Configuration> newApplication() {
            return new FakeApplication();
        }
    };

    public DropwizardClientRule(Object ... resources) {
        this.resources = resources;
    }

    public URI baseUri() {
        return URI.create("http://localhost:" + this.testSupport.getLocalPort() + "/application");
    }

    protected void before() throws Throwable {
        this.testSupport.before();
    }

    protected void after() {
        this.testSupport.after();
    }

    private class FakeApplication
    extends Application<Configuration> {
        private FakeApplication() {
        }

        public void run(Configuration configuration, Environment environment) {
            SimpleServerFactory serverConfig = new SimpleServerFactory();
            configuration.setServerFactory((ServerFactory)serverConfig);
            HttpConnectorFactory connectorConfig = (HttpConnectorFactory)serverConfig.getConnector();
            connectorConfig.setPort(0);
            environment.healthChecks().register("dummy", (HealthCheck)new DummyHealthCheck());
            for (Object resource : DropwizardClientRule.this.resources) {
                environment.jersey().register(resource);
            }
        }
    }

    private static class DummyHealthCheck
    extends HealthCheck {
        private DummyHealthCheck() {
        }

        protected HealthCheck.Result check() {
            return HealthCheck.Result.healthy();
        }
    }
}

