/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.cli.Command;
import io.dropwizard.cli.ServerCommand;
import io.dropwizard.configuration.YamlConfigurationFactory;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.POJOConfigurationFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.sourceforge.argparse4j.inf.Namespace;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;

public class DropwizardTestSupport<C extends Configuration> {
    protected final Class<? extends Application<C>> applicationClass;
    protected final String configPath;
    protected final Set<ConfigOverride> configOverrides;
    protected final Optional<String> customPropertyPrefix;
    protected final Function<Application<C>, Command> commandInstantiator;
    protected final boolean explicitConfig;
    protected C configuration;
    protected Application<C> application;
    protected Environment environment;
    protected Server jettyServer;
    protected List<ServiceListener<C>> listeners = new ArrayList<ServiceListener<C>>();

    public DropwizardTestSupport(Class<? extends Application<C>> applicationClass, @Nullable String configPath, ConfigOverride ... configOverrides) {
        this(applicationClass, configPath, Optional.empty(), configOverrides);
    }

    public DropwizardTestSupport(Class<? extends Application<C>> applicationClass, String configPath, Optional<String> customPropertyPrefix, ConfigOverride ... configOverrides) {
        this(applicationClass, configPath, customPropertyPrefix, ServerCommand::new, configOverrides);
    }

    public DropwizardTestSupport(Class<? extends Application<C>> applicationClass, String configPath, Optional<String> customPropertyPrefix, Function<Application<C>, Command> commandInstantiator, ConfigOverride ... configOverrides) {
        this.applicationClass = applicationClass;
        this.configPath = configPath;
        this.configOverrides = ImmutableSet.copyOf((Object[])((ConfigOverride[])MoreObjects.firstNonNull((Object)configOverrides, (Object)new ConfigOverride[0])));
        this.customPropertyPrefix = customPropertyPrefix;
        this.explicitConfig = false;
        this.commandInstantiator = commandInstantiator;
    }

    public DropwizardTestSupport(Class<? extends Application<C>> applicationClass, C configuration) {
        this(applicationClass, configuration, ServerCommand::new);
    }

    public DropwizardTestSupport(Class<? extends Application<C>> applicationClass, C configuration, Function<Application<C>, Command> commandInstantiator) {
        if (configuration == null) {
            throw new IllegalArgumentException("Can not pass null configuration for explicitly configured instance");
        }
        this.applicationClass = applicationClass;
        this.configPath = "";
        this.configOverrides = ImmutableSet.of();
        this.customPropertyPrefix = Optional.empty();
        this.configuration = configuration;
        this.explicitConfig = true;
        this.commandInstantiator = commandInstantiator;
    }

    public DropwizardTestSupport<C> addListener(ServiceListener<C> listener) {
        this.listeners.add(listener);
        return this;
    }

    public DropwizardTestSupport<C> manage(final Managed managed) {
        return this.addListener(new ServiceListener<C>(){

            @Override
            public void onRun(C configuration, Environment environment, DropwizardTestSupport<C> rule) throws Exception {
                environment.lifecycle().manage(managed);
            }
        });
    }

    public void before() {
        this.applyConfigOverrides();
        this.startIfRequired();
    }

    public void after() {
        try {
            this.stopIfRequired();
        }
        finally {
            this.resetConfigOverrides();
        }
    }

    private void stopIfRequired() {
        if (this.jettyServer != null) {
            for (ServiceListener<C> listener : this.listeners) {
                try {
                    listener.onStop(this);
                }
                catch (Exception exception) {}
            }
            try {
                this.jettyServer.stop();
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                this.jettyServer = null;
            }
        }
        this.configuration.getLoggingFactory().reset();
    }

    private void applyConfigOverrides() {
        for (ConfigOverride configOverride : this.configOverrides) {
            configOverride.addToSystemProperties();
        }
    }

    private void resetConfigOverrides() {
        for (ConfigOverride configOverride : this.configOverrides) {
            configOverride.removeFromSystemProperties();
        }
    }

    private void startIfRequired() {
        if (this.jettyServer != null) {
            return;
        }
        try {
            this.application = this.newApplication();
            Bootstrap bootstrap = new Bootstrap<C>(this.application){

                public void run(C configuration, Environment environment) throws Exception {
                    environment.lifecycle().addServerLifecycleListener(server -> {
                        DropwizardTestSupport.this.jettyServer = server;
                    });
                    DropwizardTestSupport.this.configuration = configuration;
                    DropwizardTestSupport.this.environment = environment;
                    super.run(configuration, environment);
                    for (ServiceListener listener : DropwizardTestSupport.this.listeners) {
                        try {
                            listener.onRun(configuration, environment, DropwizardTestSupport.this);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException("Error running app rule start listener", ex);
                        }
                    }
                }
            };
            if (this.explicitConfig) {
                bootstrap.setConfigurationFactoryFactory((klass, validator, objectMapper, propertyPrefix) -> new POJOConfigurationFactory<C>(this.configuration));
            } else if (this.customPropertyPrefix.isPresent()) {
                bootstrap.setConfigurationFactoryFactory((klass, validator, objectMapper, propertyPrefix) -> new YamlConfigurationFactory(klass, validator, objectMapper, this.customPropertyPrefix.get()));
            }
            this.application.initialize(bootstrap);
            Command command = this.commandInstantiator.apply(this.application);
            ImmutableMap.Builder file = ImmutableMap.builder();
            if (!Strings.isNullOrEmpty((String)this.configPath)) {
                file.put((Object)"file", (Object)this.configPath);
            }
            Namespace namespace = new Namespace((Map)file.build());
            command.run(bootstrap, namespace);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public C getConfiguration() {
        return this.configuration;
    }

    public int getLocalPort() {
        return ((ServerConnector)this.jettyServer.getConnectors()[0]).getLocalPort();
    }

    public int getAdminPort() {
        Connector[] connectors = this.jettyServer.getConnectors();
        return ((ServerConnector)connectors[connectors.length - 1]).getLocalPort();
    }

    public int getPort(int connectorIndex) {
        return ((ServerConnector)this.jettyServer.getConnectors()[connectorIndex]).getLocalPort();
    }

    public Application<C> newApplication() {
        try {
            return this.applicationClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public <A extends Application<C>> A getApplication() {
        return (A)this.application;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public ObjectMapper getObjectMapper() {
        return this.getEnvironment().getObjectMapper();
    }

    public static abstract class ServiceListener<T extends Configuration> {
        public void onRun(T configuration, Environment environment, DropwizardTestSupport<T> rule) throws Exception {
        }

        public void onStop(DropwizardTestSupport<T> rule) throws Exception {
        }
    }
}

