/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing.junit;

import java.lang.reflect.Method;
import java.util.Objects;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.mockito.junit.MockitoRule;

public class MockitoTestRule
implements TestRule {
    private final Object testInstance;
    private final MockitoRule delegate;

    public MockitoTestRule(Object testInstance, MockitoRule delegate) {
        this.testInstance = Objects.requireNonNull(testInstance, "test instance");
        this.delegate = Objects.requireNonNull(delegate, "MockitoRule");
    }

    public Statement apply(Statement base, Description description) {
        FrameworkMethod frameworkMethod;
        if (description.isEmpty()) {
            return base;
        }
        Class testClass = description.getTestClass();
        try {
            Method method = testClass.getMethod(description.getMethodName(), new Class[0]);
            frameworkMethod = new FrameworkMethod(method);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        return this.delegate.apply(base, frameworkMethod, this.testInstance);
    }
}

