/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing.common;

import io.dropwizard.jersey.DropwizardResourceConfig;
import io.dropwizard.jersey.jackson.JacksonFeature;
import io.dropwizard.jersey.validation.HibernateValidationBinder;
import io.dropwizard.setup.ExceptionMapperBinder;
import io.dropwizard.testing.common.ResourceTestJerseyConfiguration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Context;

class DropwizardTestResourceConfig
extends DropwizardResourceConfig {
    static final Map<String, ResourceTestJerseyConfiguration> CONFIGURATION_REGISTRY = new ConcurrentHashMap<String, ResourceTestJerseyConfiguration>();
    static final String CONFIGURATION_ID = "io.dropwizard.testing.junit.resourceTestJerseyConfigurationId";

    DropwizardTestResourceConfig(ResourceTestJerseyConfiguration configuration) {
        if (configuration.registerDefaultExceptionMappers) {
            this.register(new ExceptionMapperBinder(false));
        }
        for (Class<?> clazz : configuration.providers) {
            this.register(clazz);
        }
        this.property("jersey.config.server.response.setStatusOverSendError", "true");
        for (Map.Entry entry : configuration.properties.entrySet()) {
            this.property((String)entry.getKey(), entry.getValue());
        }
        this.register(new JacksonFeature(configuration.mapper));
        this.register(new HibernateValidationBinder(configuration.validator));
        for (Supplier supplier : configuration.singletons) {
            this.register(supplier.get());
        }
    }

    DropwizardTestResourceConfig(@Context ServletConfig servletConfig) {
        this(DropwizardTestResourceConfig.getConfiguration(servletConfig));
    }

    private static ResourceTestJerseyConfiguration getConfiguration(@Context ServletConfig servletConfig) {
        String id = Objects.requireNonNull(servletConfig.getInitParameter(CONFIGURATION_ID), "No configuration id");
        return Objects.requireNonNull(CONFIGURATION_REGISTRY.get(id), "No configuration");
    }
}

