/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing.common;

import io.dropwizard.logging.BootstrapLogging;
import java.sql.Driver;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.context.internal.ManagedSessionContext;

public class DAOTest {
    private final SessionFactory sessionFactory;

    private DAOTest(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void before() throws Throwable {
        if (ManagedSessionContext.hasBind((SessionFactory)this.sessionFactory)) {
            return;
        }
        Session session = this.sessionFactory.openSession();
        ManagedSessionContext.bind((Session)session);
    }

    public void after() {
        if (!ManagedSessionContext.hasBind((SessionFactory)this.sessionFactory)) {
            return;
        }
        Session currentSession = this.sessionFactory.getCurrentSession();
        if (currentSession.isOpen()) {
            currentSession.close();
        }
        ManagedSessionContext.unbind((SessionFactory)this.sessionFactory);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public <T> T inTransaction(Callable<T> call) {
        Session session = this.sessionFactory.getCurrentSession();
        Transaction transaction = session.beginTransaction();
        try {
            T result = call.call();
            transaction.commit();
            return result;
        }
        catch (Exception e) {
            transaction.rollback();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public void inTransaction(Runnable action) {
        this.inTransaction(() -> {
            action.run();
            return true;
        });
    }

    public static abstract class Builder<B extends Builder<B>> {
        private String url = "jdbc:h2:mem:" + UUID.randomUUID();
        private String username = "sa";
        private String password = "";
        private String driver = "org.h2.Driver";
        private String hbm2ddlAuto = "create";
        private boolean showSql = false;
        private boolean useSqlComments = false;
        private boolean bootstrapLogging = true;
        private Set<Class<?>> entityClasses = new LinkedHashSet();
        private Map<String, String> properties = new HashMap<String, String>();
        private Consumer<Configuration> configurationCustomizer = c -> {};

        public B setUrl(String url) {
            this.url = url;
            return (B)this;
        }

        public B setUsername(String username) {
            this.username = username;
            return (B)this;
        }

        public B setDriver(Class<? extends Driver> driver) {
            this.driver = driver.getName();
            return (B)this;
        }

        public B setHbm2DdlAuto(String hbm2ddlAuto) {
            this.hbm2ddlAuto = hbm2ddlAuto;
            return (B)this;
        }

        public B setShowSql(boolean showSql) {
            this.showSql = showSql;
            return (B)this;
        }

        public B useSqlComments(boolean useSqlComments) {
            this.useSqlComments = useSqlComments;
            return (B)this;
        }

        public B bootstrapLogging(boolean value) {
            this.bootstrapLogging = value;
            return (B)this;
        }

        public B addEntityClass(Class<?> entityClass) {
            this.entityClasses.add(entityClass);
            return (B)this;
        }

        public B setProperty(String key, String value) {
            this.properties.put(key, value);
            return (B)this;
        }

        public B customizeConfiguration(Consumer<Configuration> configurationCustomizer) {
            this.configurationCustomizer = configurationCustomizer;
            return (B)this;
        }

        protected DAOTest buildDAOTest() {
            if (this.bootstrapLogging) {
                BootstrapLogging.bootstrap();
            }
            Configuration config = new Configuration();
            config.setProperty("hibernate.connection.url", this.url);
            config.setProperty("hibernate.connection.username", this.username);
            config.setProperty("hibernate.connection.password", this.password);
            config.setProperty("hibernate.connection.driver_class", this.driver);
            config.setProperty("hibernate.hbm2ddl.auto", this.hbm2ddlAuto);
            config.setProperty("hibernate.show_sql", String.valueOf(this.showSql));
            config.setProperty("hibernate.use_sql_comments", String.valueOf(this.useSqlComments));
            config.setProperty("hibernate.current_session_context_class", "managed");
            config.setProperty("hibernate.jdbc.use_get_generated_keys", "true");
            config.setProperty("hibernate.generate_statistics", "true");
            config.setProperty("hibernate.bytecode.use_reflection_optimizer", "true");
            config.setProperty("hibernate.order_updates", "true");
            config.setProperty("hibernate.order_inserts", "true");
            config.setProperty("hibernate.id.new_generator_mappings", "true");
            config.setProperty("jadira.usertype.autoRegisterUserTypes", "true");
            this.entityClasses.forEach(arg_0 -> ((Configuration)config).addAnnotatedClass(arg_0));
            this.properties.forEach((arg_0, arg_1) -> ((Configuration)config).setProperty(arg_0, arg_1));
            this.configurationCustomizer.accept(config);
            return new DAOTest(config.buildSessionFactory());
        }
    }
}

