/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.YamlConfigurationFactory;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.cli.Command;
import io.dropwizard.core.cli.ConfiguredCommand;
import io.dropwizard.core.cli.EnvironmentCommand;
import io.dropwizard.core.cli.ServerCommand;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.logging.common.LoggingUtil;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.POJOConfigurationFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.validation.constraints.NotNull;
import net.sourceforge.argparse4j.inf.Namespace;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;

public class DropwizardTestSupport<C extends Configuration> {
    protected final Class<? extends Application<C>> applicationClass;
    protected final @Nullable String configPath;
    protected final @Nullable ConfigurationSourceProvider configSourceProvider;
    protected final Set<ConfigOverride> configOverrides;
    protected final @Nullable String customPropertyPrefix;
    protected final Function<Application<C>, Command> commandInstantiator;
    protected final boolean explicitConfig;
    protected @Nullable C configuration;
    protected @Nullable Application<C> application;
    protected @Nullable Environment environment;
    protected @Nullable Server jettyServer;
    protected List<ServiceListener<C>> listeners = new ArrayList<ServiceListener<C>>();

    public DropwizardTestSupport(Class<? extends Application<C>> applicationClass, @Nullable String configPath, ConfigOverride ... configOverrides) {
        this(applicationClass, configPath, (String)null, configOverrides);
    }

    public DropwizardTestSupport(Class<? extends Application<C>> applicationClass, @Nullable String configPath, @Nullable ConfigurationSourceProvider configSourceProvider, ConfigOverride ... configOverrides) {
        this((Class<Application<C>>)applicationClass, configPath, configSourceProvider, (String)null, configOverrides);
    }

    public DropwizardTestSupport(Class<? extends Application<C>> applicationClass, @Nullable String configPath, @Nullable ConfigurationSourceProvider configSourceProvider, @Nullable String customPropertyPrefix, ConfigOverride ... configOverrides) {
        this(applicationClass, configPath, configSourceProvider, customPropertyPrefix, ServerCommand::new, configOverrides);
    }

    public DropwizardTestSupport(Class<? extends Application<C>> applicationClass, @Nullable String configPath, @Nullable String customPropertyPrefix, ConfigOverride ... configOverrides) {
        this(applicationClass, configPath, customPropertyPrefix, ServerCommand::new, configOverrides);
    }

    public DropwizardTestSupport(Class<? extends Application<C>> applicationClass, @Nullable String configPath, @Nullable String customPropertyPrefix, Function<Application<C>, Command> commandInstantiator, ConfigOverride ... configOverrides) {
        this(applicationClass, configPath, null, customPropertyPrefix, commandInstantiator, configOverrides);
    }

    public DropwizardTestSupport(Class<? extends Application<C>> applicationClass, @Nullable String configPath, @Nullable ConfigurationSourceProvider configSourceProvider, @Nullable String customPropertyPrefix, Function<Application<C>, Command> commandInstantiator, ConfigOverride ... configOverrides) {
        this.applicationClass = applicationClass;
        this.configPath = configPath;
        this.configSourceProvider = configSourceProvider;
        this.configOverrides = Optional.ofNullable(configOverrides).map(Set::of).orElse(Set.of());
        this.customPropertyPrefix = customPropertyPrefix;
        this.explicitConfig = false;
        this.commandInstantiator = commandInstantiator;
    }

    public DropwizardTestSupport(Class<? extends Application<C>> applicationClass, C configuration) {
        this(applicationClass, configuration, ServerCommand::new);
    }

    public DropwizardTestSupport(Class<? extends Application<C>> applicationClass, @Nullable C configuration, Function<Application<C>, Command> commandInstantiator) {
        if (configuration == null) {
            throw new IllegalArgumentException("Can not pass null configuration for explicitly configured instance");
        }
        this.applicationClass = applicationClass;
        this.configPath = "";
        this.configSourceProvider = null;
        this.configOverrides = Collections.emptySet();
        this.customPropertyPrefix = null;
        this.configuration = configuration;
        this.explicitConfig = true;
        this.commandInstantiator = commandInstantiator;
    }

    public DropwizardTestSupport<C> addListener(ServiceListener<C> listener) {
        this.listeners.add(listener);
        return this;
    }

    public DropwizardTestSupport<C> manage(final Managed managed) {
        return this.addListener(new ServiceListener<C>(){

            @Override
            public void onRun(C configuration, Environment environment, DropwizardTestSupport<C> rule) throws Exception {
                environment.lifecycle().manage(managed);
            }
        });
    }

    public void before() throws Exception {
        this.applyConfigOverrides();
        try {
            this.startIfRequired();
        }
        catch (Exception e) {
            this.after();
            throw e;
        }
    }

    public void after() {
        try {
            this.stopIfRequired();
        }
        finally {
            this.resetConfigOverrides();
        }
    }

    private void stopIfRequired() {
        if (this.jettyServer != null) {
            for (ServiceListener<C> listener : this.listeners) {
                try {
                    listener.onStop(this);
                }
                catch (Exception exception) {}
            }
            try {
                this.jettyServer.stop();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.jettyServer = null;
            }
        }
        if (this.configuration != null) {
            this.configuration.getLoggingFactory().reset();
        } else {
            LoggingUtil.getLoggerContext().getLogger("ROOT").detachAndStopAllAppenders();
        }
    }

    private void applyConfigOverrides() {
        this.configOverrides.forEach(ConfigOverride::addToSystemProperties);
    }

    private void resetConfigOverrides() {
        this.configOverrides.forEach(ConfigOverride::removeFromSystemProperties);
    }

    private void startIfRequired() throws Exception {
        if (this.jettyServer != null) {
            return;
        }
        this.application = this.newApplication();
        Bootstrap bootstrap = new Bootstrap<C>((Application)this.getApplication()){

            public void run(C configuration, Environment environment) throws Exception {
                environment.lifecycle().addServerLifecycleListener(server -> {
                    DropwizardTestSupport.this.jettyServer = server;
                });
                super.run(configuration, environment);
                for (ServiceListener listener : DropwizardTestSupport.this.listeners) {
                    try {
                        listener.onRun(configuration, environment, DropwizardTestSupport.this);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Error running app rule start listener", ex);
                    }
                }
            }
        };
        this.getApplication().initialize(bootstrap);
        if (this.configSourceProvider != null) {
            bootstrap.setConfigurationSourceProvider(this.configSourceProvider);
        }
        if (this.explicitConfig) {
            bootstrap.setConfigurationFactoryFactory((klass, validator, objectMapper, propertyPrefix) -> new POJOConfigurationFactory<C>(this.getConfiguration()));
        } else if (this.customPropertyPrefix != null) {
            @NotNull String prefix = this.customPropertyPrefix;
            bootstrap.setConfigurationFactoryFactory((klass, validator, objectMapper, propertyPrefix) -> new YamlConfigurationFactory(klass, validator, objectMapper, prefix));
        }
        Map namespaceAttributes = Optional.ofNullable(this.configPath).filter(path -> !path.isEmpty()).map(path -> Collections.singletonMap("file", path)).orElse(Collections.emptyMap());
        Namespace namespace = new Namespace(namespaceAttributes);
        Command command = this.commandInstantiator.apply(this.application);
        command.run(bootstrap, namespace);
        if (command instanceof EnvironmentCommand) {
            EnvironmentCommand environmentCommand = (EnvironmentCommand)command;
            this.configuration = environmentCommand.getConfiguration();
            this.environment = environmentCommand.getEnvironment();
        } else if (command instanceof ConfiguredCommand) {
            ConfiguredCommand configuredCommand = (ConfiguredCommand)command;
            this.configuration = configuredCommand.getConfiguration();
        }
    }

    public C getConfiguration() {
        return (C)((Configuration)Objects.requireNonNull(this.configuration, "configuration"));
    }

    public int getLocalPort() {
        return this.getPort(0);
    }

    public int getAdminPort() {
        Connector[] connectors = Objects.requireNonNull(this.jettyServer, "jettyServer").getConnectors();
        return ((ServerConnector)connectors[connectors.length - 1]).getLocalPort();
    }

    public int getPort(int connectorIndex) {
        return ((ServerConnector)Objects.requireNonNull(this.jettyServer, "jettyServer").getConnectors()[connectorIndex]).getLocalPort();
    }

    public Application<C> newApplication() {
        try {
            return this.applicationClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public <A extends Application<C>> A getApplication() {
        return (A)Objects.requireNonNull(this.application, "application");
    }

    public Environment getEnvironment() {
        return Objects.requireNonNull(this.environment, "environment");
    }

    public ObjectMapper getObjectMapper() {
        return this.getEnvironment().getObjectMapper();
    }

    public static abstract class ServiceListener<T extends Configuration> {
        public void onRun(T configuration, Environment environment, DropwizardTestSupport<T> rule) throws Exception {
        }

        public void onStop(DropwizardTestSupport<T> rule) throws Exception {
        }
    }
}

