/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing.junit5;

import io.dropwizard.testing.junit5.DropwizardExtension;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.ReflectionSupport;

public class DropwizardExtensionsSupport
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback {
    private static Set<Field> findAnnotatedFields(Class<?> testClass, boolean isStaticMember) {
        Set<Field> set = Arrays.stream(testClass.getDeclaredFields()).filter(m -> isStaticMember == Modifier.isStatic(m.getModifiers())).filter(m -> DropwizardExtension.class.isAssignableFrom(m.getType())).collect(Collectors.toSet());
        if (!testClass.getSuperclass().equals(Object.class)) {
            set.addAll(DropwizardExtensionsSupport.findAnnotatedFields(testClass.getSuperclass(), isStaticMember));
        }
        return set;
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        try {
            this.afterAll(extensionContext.getRequiredTestClass());
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    private void afterAll(Class<?> cls) throws Throwable {
        Class<?> enclosingClass = cls.getEnclosingClass();
        if (enclosingClass != null) {
            this.afterAll(enclosingClass);
        }
        for (Field member : DropwizardExtensionsSupport.findAnnotatedFields(cls, true)) {
            this.getDropwizardExtension(member, null).after();
        }
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        Object testInstance = extensionContext.getTestInstance().orElseThrow(() -> new IllegalStateException("Unable to get the current test instance"));
        try {
            this.afterEach(testInstance, testInstance.getClass());
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    private void afterEach(Object testInstance, Class<?> cls) throws Throwable {
        Object enclosing;
        Class<?> enclosingClass = cls.getEnclosingClass();
        if (enclosingClass != null && (enclosing = this.getEnclosingInstance(testInstance)) != null) {
            this.afterEach(enclosing, cls);
        }
        for (Field member : DropwizardExtensionsSupport.findAnnotatedFields(testInstance.getClass(), false)) {
            this.getDropwizardExtension(member, testInstance).after();
        }
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        try {
            this.beforeAll(extensionContext.getRequiredTestClass());
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    private void beforeAll(Class<?> cls) throws Throwable {
        Class<?> enclosingClass = cls.getEnclosingClass();
        if (enclosingClass != null) {
            this.beforeAll(enclosingClass);
        }
        for (Field member : DropwizardExtensionsSupport.findAnnotatedFields(cls, true)) {
            this.getDropwizardExtension(member, null).before();
        }
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        Object testInstance = extensionContext.getTestInstance().orElseThrow(() -> new IllegalStateException("Unable to get the current test instance"));
        try {
            this.beforeEach(testInstance, testInstance.getClass());
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    private void beforeEach(Object testInstance, Class<?> cls) throws Throwable {
        Object enclosing;
        Class<?> enclosingClass = cls.getEnclosingClass();
        if (enclosingClass != null && (enclosing = this.getEnclosingInstance(testInstance)) != null) {
            this.beforeEach(enclosing, cls);
        }
        for (Field member : DropwizardExtensionsSupport.findAnnotatedFields(testInstance.getClass(), false)) {
            this.getDropwizardExtension(member, testInstance).before();
        }
    }

    private @Nullable Object getEnclosingInstance(Object o) throws IllegalAccessException {
        Class<?> innerClass = o.getClass();
        if (innerClass.getEnclosingClass() == null) {
            return null;
        }
        for (int i = 0; i < 10; ++i) {
            try {
                Field field = innerClass.getDeclaredField("this$" + i);
                field.setAccessible(true);
                return field.get(o);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    private DropwizardExtension getDropwizardExtension(Field member, @Nullable Object o) {
        return (DropwizardExtension)ReflectionSupport.tryToReadFieldValue((Field)member, (Object)o).andThenTry(DropwizardExtension.class::cast).getOrThrow(e -> new IllegalStateException("Failed to read " + DropwizardExtension.class.getSimpleName() + " field: " + member, (Throwable)e));
    }
}

