/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing.junit5;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.cli.Command;
import io.dropwizard.core.cli.ServerCommand;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.jersey.jackson.JacksonFeature;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.DropwizardTestSupport;
import io.dropwizard.testing.junit5.DropwizardExtension;
import jakarta.ws.rs.client.Client;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glassfish.jersey.apache5.connector.Apache5ConnectorProvider;
import org.glassfish.jersey.apache5.connector.Apache5HttpClientBuilderConfigurator;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class DropwizardAppExtension<C extends Configuration>
implements DropwizardExtension,
BeforeAllCallback,
AfterAllCallback {
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 1000;
    private static final int DEFAULT_READ_TIMEOUT_MS = 5000;
    private final DropwizardTestSupport<C> testSupport;
    private final AtomicInteger recursiveCallCount = new AtomicInteger(0);
    private @Nullable Client client;

    public DropwizardAppExtension(Class<? extends Application<C>> applicationClass) {
        this(applicationClass, (String)null, new ConfigOverride[0]);
    }

    public DropwizardAppExtension(Class<? extends Application<C>> applicationClass, @Nullable String configPath, ConfigOverride ... configOverrides) {
        this(applicationClass, configPath, (String)null, configOverrides);
    }

    public DropwizardAppExtension(Class<? extends Application<C>> applicationClass, @Nullable String configPath, ConfigurationSourceProvider configSourceProvider, ConfigOverride ... configOverrides) {
        this((Class<Application<C>>)applicationClass, configPath, configSourceProvider, (String)null, configOverrides);
    }

    public DropwizardAppExtension(Class<? extends Application<C>> applicationClass, @Nullable String configPath, @Nullable String customPropertyPrefix, ConfigOverride ... configOverrides) {
        this(applicationClass, configPath, customPropertyPrefix, ServerCommand::new, configOverrides);
    }

    public DropwizardAppExtension(Class<? extends Application<C>> applicationClass, @Nullable String configPath, ConfigurationSourceProvider configSourceProvider, @Nullable String customPropertyPrefix, ConfigOverride ... configOverrides) {
        this(applicationClass, configPath, configSourceProvider, customPropertyPrefix, ServerCommand::new, configOverrides);
    }

    public DropwizardAppExtension(Class<? extends Application<C>> applicationClass, @Nullable String configPath, @Nullable String customPropertyPrefix, Function<Application<C>, Command> commandInstantiator, ConfigOverride ... configOverrides) {
        this(new DropwizardTestSupport<C>(applicationClass, configPath, customPropertyPrefix, commandInstantiator, configOverrides));
    }

    public DropwizardAppExtension(Class<? extends Application<C>> applicationClass, @Nullable String configPath, ConfigurationSourceProvider configSourceProvider, @Nullable String customPropertyPrefix, Function<Application<C>, Command> commandInstantiator, ConfigOverride ... configOverrides) {
        this(new DropwizardTestSupport<C>(applicationClass, configPath, configSourceProvider, customPropertyPrefix, commandInstantiator, configOverrides));
    }

    public DropwizardAppExtension(Class<? extends Application<C>> applicationClass, C configuration) {
        this(new DropwizardTestSupport<C>(applicationClass, configuration));
    }

    public DropwizardAppExtension(Class<? extends Application<C>> applicationClass, C configuration, Function<Application<C>, Command> commandInstantiator) {
        this(new DropwizardTestSupport<C>(applicationClass, configuration, commandInstantiator));
    }

    public DropwizardAppExtension(DropwizardTestSupport<C> testSupport) {
        this.testSupport = testSupport;
    }

    public DropwizardAppExtension<C> addListener(final ServiceListener<C> listener) {
        this.testSupport.addListener(new DropwizardTestSupport.ServiceListener<C>(){

            @Override
            public void onRun(C configuration, Environment environment, DropwizardTestSupport<C> rule) throws Exception {
                listener.onRun(configuration, environment, DropwizardAppExtension.this);
            }

            @Override
            public void onStop(DropwizardTestSupport<C> rule) throws Exception {
                listener.onStop(DropwizardAppExtension.this);
            }
        });
        return this;
    }

    public DropwizardAppExtension<C> manage(final Managed managed) {
        return this.addListener(new ServiceListener<C>(){

            @Override
            public void onRun(C configuration, Environment environment, DropwizardAppExtension<C> rule) throws Exception {
                environment.lifecycle().manage(managed);
            }
        });
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.before();
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.after();
    }

    @Override
    public void before() throws Exception {
        if (this.recursiveCallCount.getAndIncrement() == 0) {
            this.testSupport.before();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void after() {
        if (this.recursiveCallCount.decrementAndGet() == 0) {
            this.testSupport.after();
            DropwizardAppExtension dropwizardAppExtension = this;
            synchronized (dropwizardAppExtension) {
                if (this.client != null) {
                    this.client.close();
                    this.client = null;
                }
            }
        }
    }

    public C getConfiguration() {
        return this.testSupport.getConfiguration();
    }

    public int getLocalPort() {
        return this.testSupport.getLocalPort();
    }

    public int getPort(int connectorIndex) {
        return this.testSupport.getPort(connectorIndex);
    }

    public int getAdminPort() {
        return this.testSupport.getAdminPort();
    }

    public Application<C> newApplication() {
        return this.testSupport.newApplication();
    }

    public <A extends Application<C>> A getApplication() {
        return this.testSupport.getApplication();
    }

    public Environment getEnvironment() {
        return this.testSupport.getEnvironment();
    }

    public ObjectMapper getObjectMapper() {
        return this.testSupport.getObjectMapper();
    }

    public DropwizardTestSupport<C> getTestSupport() {
        return this.testSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client client() {
        DropwizardAppExtension dropwizardAppExtension = this;
        synchronized (dropwizardAppExtension) {
            if (this.client == null) {
                this.client = this.clientBuilder().build();
            }
            return this.client;
        }
    }

    protected JerseyClientBuilder clientBuilder() {
        ClientConfig clientConfig = new ClientConfig();
        Apache5HttpClientBuilderConfigurator contentCompressionConfigurator = httpClientBuilder -> httpClientBuilder.disableContentCompression().addResponseInterceptorLast((HttpResponseInterceptor)new BufferingHttpResponseInterceptor());
        clientConfig.connectorProvider((ConnectorProvider)new Apache5ConnectorProvider()).register((Object)new JacksonFeature(this.getObjectMapper())).register((Object)contentCompressionConfigurator).property("jersey.config.client.connectTimeout", (Object)1000).property("jersey.config.client.readTimeout", (Object)5000).property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
        return new JerseyClientBuilder().withConfig((jakarta.ws.rs.core.Configuration)clientConfig);
    }

    public static class BufferingHttpResponseInterceptor
    implements HttpResponseInterceptor {
        public void process(HttpResponse response, EntityDetails entity, HttpContext context) throws HttpException, IOException {
            if (!(response instanceof HttpEntityContainer)) {
                return;
            }
            HttpEntityContainer httpEntityContainer = (HttpEntityContainer)response;
            HttpEntity httpEntity = httpEntityContainer.getEntity();
            if (httpEntity == null) {
                return;
            }
            int initialSize = httpEntity.getContentLength() > 0L && httpEntity.getContentLength() < Integer.MAX_VALUE ? (int)httpEntity.getContentLength() : 32;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(initialSize);
            httpEntity.writeTo((OutputStream)byteArrayOutputStream);
            httpEntity.getContent().close();
            ByteArrayEntity newHttpEntity = new ByteArrayEntity(byteArrayOutputStream.toByteArray(), httpEntity.getContentType() != null ? ContentType.parse((CharSequence)httpEntity.getContentType()) : null, httpEntity.getContentEncoding());
            httpEntityContainer.setEntity((HttpEntity)newHttpEntity);
        }
    }

    public static abstract class ServiceListener<T extends Configuration> {
        public void onRun(T configuration, Environment environment, DropwizardAppExtension<T> rule) throws Exception {
        }

        public void onStop(DropwizardAppExtension<T> rule) throws Exception {
        }
    }
}

