/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing;

import io.dropwizard.testing.ConfigOverride;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConfigOverrideValue
extends ConfigOverride {
    private final String key;
    private final Supplier<String> value;
    private final String propertyPrefix;
    private @Nullable String originalValue = null;

    ConfigOverrideValue(String propertyPrefix, String key, Supplier<String> value) {
        this.key = key;
        this.value = value;
        this.propertyPrefix = propertyPrefix.endsWith(".") ? propertyPrefix : propertyPrefix + ".";
    }

    @Override
    public void addToSystemProperties() {
        this.originalValue = System.setProperty(this.propertyPrefix + this.key, this.value.get());
    }

    @Override
    public void removeFromSystemProperties() {
        if (this.originalValue != null) {
            System.setProperty(this.propertyPrefix + this.key, this.originalValue);
        } else {
            System.clearProperty(this.propertyPrefix + this.key);
        }
    }
}

