/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing.common;

import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.server.ServerFactory;
import io.dropwizard.core.server.SimpleServerFactory;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.jetty.HttpConnectorFactory;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.DropwizardTestSupport;
import java.net.URI;

public class DropwizardClient {
    private final Object[] resources;
    private final DropwizardTestSupport<Configuration> testSupport = new DropwizardTestSupport<Configuration>(FakeApplication.class, "", new ConfigOverride[0]){

        @Override
        public Application<Configuration> newApplication() {
            return new FakeApplication();
        }
    };

    public DropwizardClient(Object ... resources) {
        this.resources = resources;
    }

    public URI baseUri() {
        return URI.create("http://localhost:" + this.testSupport.getLocalPort() + "/application");
    }

    public ObjectMapper getObjectMapper() {
        return this.testSupport.getObjectMapper();
    }

    public Environment getEnvironment() {
        return this.testSupport.getEnvironment();
    }

    public void before() throws Throwable {
        this.testSupport.before();
    }

    public void after() {
        this.testSupport.after();
    }

    private class FakeApplication
    extends Application<Configuration> {
        private FakeApplication() {
        }

        public void run(Configuration configuration, Environment environment) {
            SimpleServerFactory serverConfig = new SimpleServerFactory();
            configuration.setServerFactory((ServerFactory)serverConfig);
            HttpConnectorFactory connectorConfig = (HttpConnectorFactory)serverConfig.getConnector();
            connectorConfig.setPort(0);
            environment.healthChecks().register("dummy", (HealthCheck)new DummyHealthCheck());
            for (Object resource : DropwizardClient.this.resources) {
                if (resource instanceof Class) {
                    Class classObj = (Class)resource;
                    environment.jersey().register(classObj);
                    continue;
                }
                environment.jersey().register(resource);
            }
        }
    }

    private static class DummyHealthCheck
    extends HealthCheck {
        private DummyHealthCheck() {
        }

        protected HealthCheck.Result check() {
            return HealthCheck.Result.healthy();
        }
    }
}

