/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class Sets {
    private Sets() {
    }

    public static <T> Set<T> of(T e1, T e2) {
        HashSet<T> set = new HashSet<T>(2);
        set.add(e1);
        set.add(e2);
        return Collections.unmodifiableSet(set);
    }

    public static <T> Set<T> of(T e1, T e2, T e3) {
        HashSet<T> set = new HashSet<T>(3);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        return Collections.unmodifiableSet(set);
    }

    public static <T> Set<T> of(T e1, T e2, T e3, T e4) {
        HashSet<T> set = new HashSet<T>(4);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        return Collections.unmodifiableSet(set);
    }

    public static <T> Set<T> of(T e1, T e2, T e3, T e4, T e5) {
        HashSet<T> set = new HashSet<T>(5);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        return Collections.unmodifiableSet(set);
    }

    @SafeVarargs
    public static <T> Set<T> of(T ... elements) {
        HashSet<T> set = new HashSet<T>(elements.length);
        set.addAll(Arrays.asList(elements));
        return Collections.unmodifiableSet(set);
    }

    public static <T> Set<T> of(Iterable<T> elements) {
        HashSet<T> set = new HashSet<T>();
        for (T element : elements) {
            set.add(element);
        }
        return Collections.unmodifiableSet(set);
    }
}

