package io.dropwizard.util;

import java.util.HashMap;
import java.util.Map;

/**
 * Helper methods to construct {@link Map} instances.
 * @since 2.0
 *
 * @deprecated this class exists to help users transition from Guava. It will be removed in Dropwizard 3.0 in favour
 *             of Java 9+'s JCL Collection methods.
 */
@Deprecated
public final class Maps {
    private Maps() {
    }

    /**
     * Construct a {@link Map} of two keys and corresponding values.
     *
     * @param k1 the first key
     * @param v1 the first value
     * @param k2 the second key
     * @param v2 the second value
     * @return a new {@link Map} containing the specified elements
     * @param <K> the type of the key elements
     * @param <V> the type of the value elements
     */
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2) {
        final Map<K, V> map = new HashMap<>();
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    /**
     * Construct a {@link Map} of three keys and corresponding values.
     *
     * @param k1 the first key
     * @param v1 the first value
     * @param k2 the second key
     * @param v2 the second value
     * @param k3 the third key
     * @param v3 the third value
     * @return a new {@link Map} containing the specified elements
     * @param <K> the type of the key elements
     * @param <V> the type of the value elements
     */
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        final Map<K, V> map = new HashMap<>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    /**
     * Construct a {@link Map} of four keys and corresponding values.
     *
     * @param k1 the first key
     * @param v1 the first value
     * @param k2 the second key
     * @param v2 the second value
     * @param k3 the third key
     * @param v3 the third value
     * @param k4 the fourth key
     * @param v4 the fourth value
     * @return a new {@link Map} containing the specified elements
     * @param <K> the type of the key elements
     * @param <V> the type of the value elements
     */
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        final Map<K, V> map = new HashMap<>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    /**
     * Construct a {@link Map} of five keys and corresponding values.
     *
     * @param k1 the first key
     * @param v1 the first value
     * @param k2 the second key
     * @param v2 the second value
     * @param k3 the third key
     * @param v3 the third value
     * @param k4 the fourth key
     * @param v4 the fourth value
     * @param k5 the fifth key
     * @param v5 the fifth value
     * @return a new {@link Map} containing the specified elements
     * @param <K> the type of the key elements
     * @param <V> the type of the value elements
     */
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        final Map<K, V> map = new HashMap<>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }
}
