/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.util;

import java.util.HashSet;
import java.util.Optional;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Throwables {
    private Throwables() {
    }

    public static Optional<Throwable> findThrowableInChain(Predicate<Throwable> condition, @Nullable Throwable t) {
        HashSet<Throwable> seen = new HashSet<Throwable>();
        while (t != null && !seen.contains(t)) {
            if (condition.test(t)) {
                return Optional.of(t);
            }
            seen.add(t);
            t = t.getCause();
        }
        return Optional.empty();
    }
}

