/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.validation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import io.dropwizard.validation.ValidationMethod;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;

public class ConstraintViolations {
    private ConstraintViolations() {
    }

    public static <T> String format(ConstraintViolation<T> v) {
        if (v.getConstraintDescriptor().getAnnotation() instanceof ValidationMethod) {
            return v.getMessage();
        }
        return String.format("%s %s", v.getPropertyPath(), v.getMessage());
    }

    public static <T> ImmutableList<String> format(Set<ConstraintViolation<T>> violations) {
        HashSet<String> errors = new HashSet<String>();
        for (ConstraintViolation<T> v : violations) {
            errors.add(ConstraintViolations.format(v));
        }
        return ImmutableList.copyOf((Collection)Ordering.natural().sortedCopy(errors));
    }

    public static ImmutableList<String> formatUntyped(Set<ConstraintViolation<?>> violations) {
        HashSet<String> errors = new HashSet<String>();
        for (ConstraintViolation<?> v : violations) {
            errors.add(ConstraintViolations.format(v));
        }
        return ImmutableList.copyOf((Collection)Ordering.natural().sortedCopy(errors));
    }

    public static <T> ImmutableSet<ConstraintViolation<?>> copyOf(Set<ConstraintViolation<T>> violations) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ConstraintViolation<T> violation : violations) {
            builder.add(violation);
        }
        return builder.build();
    }
}

