/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.views.freemarker;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import freemarker.core.HTMLOutputFormat;
import freemarker.core.OutputFormat;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.Version;
import io.dropwizard.views.View;
import io.dropwizard.views.ViewRenderException;
import io.dropwizard.views.ViewRenderer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class FreemarkerViewRenderer
implements ViewRenderer {
    private static final Pattern FILE_PATTERN = Pattern.compile("\\.ftl[hx]?");
    private final TemplateLoader loader;
    private final LoadingCache<Class<?>, Configuration> configurationCache;

    @Deprecated
    public FreemarkerViewRenderer() {
        this(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
    }

    public FreemarkerViewRenderer(Version incompatibleImprovementsVersion) {
        this.loader = new TemplateLoader(incompatibleImprovementsVersion);
        this.configurationCache = Caffeine.newBuilder().build((CacheLoader)this.loader);
    }

    public boolean isRenderable(View view) {
        return FILE_PATTERN.matcher(view.getTemplateName()).find();
    }

    public void render(View view, Locale locale, OutputStream output) throws IOException {
        Configuration configuration = (Configuration)this.configurationCache.get(view.getClass());
        if (configuration == null) {
            throw new ViewRenderException("Couldn't find view class " + view.getClass());
        }
        try {
            Charset charset = view.getCharset().orElseGet(() -> Charset.forName(configuration.getEncoding(locale)));
            Template template = configuration.getTemplate(view.getTemplateName(), locale, charset.name());
            template.process((Object)view, (Writer)new OutputStreamWriter(output, template.getEncoding()));
        }
        catch (Exception e) {
            throw new ViewRenderException((Throwable)e);
        }
    }

    public void configure(Map<String, String> baseConfig) {
        this.loader.setBaseConfig(baseConfig);
    }

    public String getConfigurationKey() {
        return "freemarker";
    }

    private static class TemplateLoader
    implements CacheLoader<Class<?>, Configuration> {
        private final Version incompatibleImprovementsVersion;
        private Map<String, String> baseConfig = Collections.emptyMap();

        private TemplateLoader(Version incompatibleImprovementsVersion) {
            this.incompatibleImprovementsVersion = incompatibleImprovementsVersion;
        }

        public Configuration load(@Nonnull Class<?> key) throws Exception {
            Configuration configuration = new Configuration(this.incompatibleImprovementsVersion);
            configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapperBuilder(this.incompatibleImprovementsVersion).build());
            configuration.loadBuiltInEncodingMap();
            configuration.setDefaultEncoding(StandardCharsets.UTF_8.name());
            configuration.setClassForTemplateLoading(key, "/");
            configuration.setOutputFormat((OutputFormat)HTMLOutputFormat.INSTANCE);
            for (Map.Entry<String, String> entry : this.baseConfig.entrySet()) {
                configuration.setSetting(entry.getKey(), entry.getValue());
            }
            return configuration;
        }

        void setBaseConfig(Map<String, String> baseConfig) {
            this.baseConfig = baseConfig;
        }
    }
}

