/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.views.mustache;

import com.github.mustachejava.MustacheResolver;
import io.dropwizard.views.common.View;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.checkerframework.checker.nullness.qual.Nullable;

class PerClassMustacheResolver
implements MustacheResolver {
    private final Class<? extends View> klass;

    PerClassMustacheResolver(Class<? extends View> klass) {
        this.klass = klass;
    }

    public @Nullable Reader getReader(String resourceName) {
        InputStream is = this.klass.getResourceAsStream(resourceName);
        if (is == null) {
            return null;
        }
        return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
    }
}

