/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.views;

import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Sets;
import io.dropwizard.views.ViewConfigurable;
import io.dropwizard.views.ViewMessageBodyWriter;
import io.dropwizard.views.ViewRenderer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class ViewBundle<T extends Configuration>
implements ConfiguredBundle<T>,
ViewConfigurable<T> {
    private final Iterable<ViewRenderer> viewRenderers;

    public ViewBundle() {
        this(ServiceLoader.load(ViewRenderer.class));
    }

    public ViewBundle(Iterable<ViewRenderer> viewRenderers) {
        this.viewRenderers = Sets.of(viewRenderers);
    }

    @Override
    public Map<String, Map<String, String>> getViewConfiguration(T configuration) {
        return Collections.emptyMap();
    }

    public void run(T configuration, Environment environment) throws Exception {
        Map<String, Map<String, String>> options = this.getViewConfiguration(configuration);
        Iterator<ViewRenderer> iterator = this.viewRenderers.iterator();
        while (iterator.hasNext()) {
            ViewRenderer viewRenderer;
            Map<String, String> viewOptions = options.get((viewRenderer = iterator.next()).getConfigurationKey());
            viewRenderer.configure(viewOptions == null ? Collections.emptyMap() : viewOptions);
        }
        environment.jersey().register((Object)new ViewMessageBodyWriter(environment.metrics(), this.viewRenderers));
    }
}

