/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.views.common;

import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.views.common.ViewConfigurable;
import io.dropwizard.views.common.ViewMessageBodyWriter;
import io.dropwizard.views.common.ViewRenderer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class ViewBundle<T>
implements ConfiguredBundle<T>,
ViewConfigurable<T> {
    private final Iterable<ViewRenderer> viewRenderers;

    public ViewBundle() {
        this(ServiceLoader.load(ViewRenderer.class));
    }

    public ViewBundle(Iterable<ViewRenderer> viewRenderers) {
        HashSet viewRendererSet = new HashSet();
        viewRenderers.forEach(viewRendererSet::add);
        this.viewRenderers = Collections.unmodifiableSet(viewRendererSet);
    }

    @Override
    public Map<String, Map<String, String>> getViewConfiguration(T configuration) {
        return Map.of();
    }

    public void run(T configuration, Environment environment) throws Exception {
        Map<String, Map<String, String>> options = this.getViewConfiguration(configuration);
        Iterator<ViewRenderer> iterator = this.viewRenderers.iterator();
        while (iterator.hasNext()) {
            ViewRenderer viewRenderer;
            Map<String, String> viewOptions = options.get((viewRenderer = iterator.next()).getConfigurationKey());
            viewRenderer.configure(viewOptions == null ? Map.of() : viewOptions);
        }
        environment.jersey().register((Object)new ViewMessageBodyWriter(environment.metrics(), this.viewRenderers));
    }
}

