/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.views.common;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.dropwizard.views.common.View;
import io.dropwizard.views.common.ViewRenderException;
import io.dropwizard.views.common.ViewRenderer;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import org.glassfish.jersey.message.internal.HeaderValueException;

@Provider
@Produces(value={"text/html", "application/xhtml+xml"})
public class ViewMessageBodyWriter
implements MessageBodyWriter<View> {
    @Context
    @Nullable
    private HttpHeaders headers;
    private final Iterable<ViewRenderer> renderers;
    private final MetricRegistry metricRegistry;

    void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public ViewMessageBodyWriter(MetricRegistry metricRegistry, Iterable<ViewRenderer> viewRenderers) {
        this.metricRegistry = metricRegistry;
        this.renderers = viewRenderers;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return View.class.isAssignableFrom(type);
    }

    public long getSize(View t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTo(View t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        Timer.Context context = this.metricRegistry.timer(MetricRegistry.name(t.getClass(), (String[])new String[]{"rendering"})).time();
        try {
            Iterator<ViewRenderer> iterator = this.renderers.iterator();
            while (iterator.hasNext()) {
                ViewRenderer renderer = iterator.next();
                if (renderer.isRenderable(t)) {
                    renderer.render(t, this.detectLocale(Objects.requireNonNull(this.headers)), entityStream);
                    return;
                }
            }
            throw new ViewRenderException("Unable to find a renderer for " + t.getTemplateName());
        }
        catch (ViewRenderException e) {
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            context.stop();
        }
    }

    protected Locale detectLocale(HttpHeaders headers) {
        List languages;
        try {
            languages = headers.getAcceptableLanguages();
        }
        catch (HeaderValueException e) {
            throw new WebApplicationException(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        for (Locale locale : languages) {
            if (locale.toString().contains("*")) continue;
            return locale;
        }
        return Locale.getDefault();
    }

    Iterable<ViewRenderer> getRenderers() {
        return this.renderers;
    }
}

