/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.graphite;

class GraphiteSanitize {
    GraphiteSanitize() {
    }

    static String sanitize(String string, char replacement) {
        String replaced = GraphiteSanitize.replaceFrom(string, replacement);
        String result = replaced.replace("--", "-");
        while (!result.equals(replaced)) {
            replaced = result;
            result = replaced.replace("--", "-");
        }
        return GraphiteSanitize.strip(result, replacement);
    }

    private static boolean matches(char c) {
        return !Character.isLetterOrDigit(c) || c > '\u007f';
    }

    private static String replaceFrom(String string, char replacement) {
        int pos = GraphiteSanitize.indexIn(string, 0);
        if (pos == -1) {
            return string;
        }
        char[] chars = string.toCharArray();
        chars[pos] = replacement;
        for (int i = pos + 1; i < chars.length; ++i) {
            if (!GraphiteSanitize.matches(chars[i])) continue;
            chars[i] = replacement;
        }
        return new String(chars).trim();
    }

    private static int indexIn(String sequence, int start) {
        int length = sequence.length();
        for (int i = start; i < length; ++i) {
            if (!GraphiteSanitize.matches(sequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static String strip(String str, char strip) {
        int start;
        int strLen = str.length();
        int end = strLen - 1;
        for (start = 0; start != strLen && str.charAt(start) == strip; ++start) {
        }
        while (end > start && str.charAt(end) == strip) {
            --end;
        }
        return start != 0 || end != strLen - 1 ? str.substring(start, end + 1) : str;
    }
}

