/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.health;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class HealthCheck {
    protected abstract Result check() throws Exception;

    public Result execute() {
        try {
            return this.check();
        }
        catch (Exception e) {
            return Result.unhealthy(e);
        }
    }

    public static class ResultBuilder {
        private boolean healthy = true;
        private String message;
        private Throwable error;
        private Map<String, Object> details = new LinkedHashMap<String, Object>();

        protected ResultBuilder() {
        }

        public ResultBuilder healthy() {
            this.healthy = true;
            return this;
        }

        public ResultBuilder unhealthy() {
            this.healthy = false;
            return this;
        }

        public ResultBuilder unhealthy(Throwable error) {
            this.error = error;
            return this.unhealthy().withMessage(error.getMessage());
        }

        public ResultBuilder withMessage(String message) {
            this.message = message;
            return this;
        }

        public ResultBuilder withMessage(String message, Object ... args) {
            return this.withMessage(String.format(message, args));
        }

        public ResultBuilder withDetail(String key, Object data) {
            if (this.details == null) {
                this.details = new LinkedHashMap<String, Object>();
            }
            this.details.put(key, data);
            return this;
        }

        public Result build() {
            return new Result(this);
        }
    }

    public static class Result {
        private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
        private static final int PRIME = 31;
        private final boolean healthy;
        private final String message;
        private final Throwable error;
        private final Map<String, Object> details;
        private final String timestamp;

        public static Result healthy() {
            return new Result(true, null, null);
        }

        public static Result healthy(String message) {
            return new Result(true, message, null);
        }

        public static Result healthy(String message, Object ... args) {
            return Result.healthy(String.format(message, args));
        }

        public static Result unhealthy(String message) {
            return new Result(false, message, null);
        }

        public static Result unhealthy(String message, Object ... args) {
            return Result.unhealthy(String.format(message, args));
        }

        public static Result unhealthy(Throwable error) {
            return new Result(false, error.getMessage(), error);
        }

        public static ResultBuilder builder() {
            return new ResultBuilder();
        }

        private Result(boolean isHealthy, String message, Throwable error) {
            this(isHealthy, message, error, null);
        }

        private Result(ResultBuilder builder) {
            this(builder.healthy, builder.message, builder.error, builder.details);
        }

        private Result(boolean isHealthy, String message, Throwable error, Map<String, Object> details) {
            this.healthy = isHealthy;
            this.message = message;
            this.error = error;
            this.details = details == null ? null : Collections.unmodifiableMap(details);
            this.timestamp = new SimpleDateFormat(DATE_FORMAT_PATTERN).format(new Date());
        }

        public boolean isHealthy() {
            return this.healthy;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getError() {
            return this.error;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public Map<String, Object> getDetails() {
            return this.details;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return !(this.healthy != result.healthy || (this.error == null ? result.error != null : !this.error.equals(result.error)) || (this.message == null ? result.message != null : !this.message.equals(result.message)) || (this.timestamp == null ? result.timestamp != null : !this.timestamp.equals(result.timestamp)));
        }

        public int hashCode() {
            int result = this.healthy ? 1 : 0;
            result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
            result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
            result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Result{isHealthy=");
            builder.append(this.healthy);
            if (this.message != null) {
                builder.append(", message=").append(this.message);
            }
            if (this.error != null) {
                builder.append(", error=").append(this.error);
            }
            builder.append(", timestamp=").append(this.timestamp);
            if (this.details != null) {
                for (Map.Entry<String, Object> e : this.details.entrySet()) {
                    builder.append(e.getKey()).append("=").append(e.getValue().toString());
                }
            }
            builder.append('}');
            return builder.toString();
        }
    }
}

