/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.health;

import com.codahale.metrics.health.AsyncHealthCheckDecorator;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistryListener;
import com.codahale.metrics.health.annotation.Async;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckRegistry.class);
    private final ConcurrentMap<String, HealthCheck> healthChecks;
    private final List<HealthCheckRegistryListener> listeners;
    private final ScheduledExecutorService asyncExecutorService;
    private final Object lock = new Object();

    public HealthCheckRegistry() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public HealthCheckRegistry(int asyncExecutorPoolSize) {
        this(HealthCheckRegistry.createExecutorService(asyncExecutorPoolSize));
    }

    public HealthCheckRegistry(ScheduledExecutorService asyncExecutorService) {
        this.healthChecks = new ConcurrentHashMap<String, HealthCheck>();
        this.listeners = new CopyOnWriteArrayList<HealthCheckRegistryListener>();
        this.asyncExecutorService = asyncExecutorService;
    }

    public void addListener(HealthCheckRegistryListener listener) {
        this.listeners.add(listener);
        for (Map.Entry entry : this.healthChecks.entrySet()) {
            listener.onHealthCheckAdded((String)entry.getKey(), (HealthCheck)entry.getValue());
        }
    }

    public void removeListener(HealthCheckRegistryListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String name, HealthCheck healthCheck) {
        HealthCheck registered = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.healthChecks.containsKey(name)) {
                registered = healthCheck;
                if (healthCheck.getClass().isAnnotationPresent(Async.class)) {
                    registered = new AsyncHealthCheckDecorator(healthCheck, this.asyncExecutorService);
                }
                this.healthChecks.put(name, registered);
            }
        }
        if (registered != null) {
            this.onHealthCheckAdded(name, registered);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String name) {
        HealthCheck healthCheck = null;
        Object object = this.lock;
        synchronized (object) {
            healthCheck = (HealthCheck)this.healthChecks.remove(name);
            if (healthCheck instanceof AsyncHealthCheckDecorator) {
                ((AsyncHealthCheckDecorator)healthCheck).tearDown();
            }
        }
        if (healthCheck != null) {
            this.onHealthCheckRemoved(name, healthCheck);
        }
    }

    public SortedSet<String> getNames() {
        return Collections.unmodifiableSortedSet(new TreeSet(this.healthChecks.keySet()));
    }

    public HealthCheck.Result runHealthCheck(String name) throws NoSuchElementException {
        HealthCheck healthCheck = (HealthCheck)this.healthChecks.get(name);
        if (healthCheck == null) {
            throw new NoSuchElementException("No health check named " + name + " exists");
        }
        return healthCheck.execute();
    }

    public SortedMap<String, HealthCheck.Result> runHealthChecks() {
        TreeMap results = new TreeMap();
        for (Map.Entry entry : this.healthChecks.entrySet()) {
            HealthCheck.Result result = ((HealthCheck)entry.getValue()).execute();
            results.put(entry.getKey(), result);
        }
        return Collections.unmodifiableSortedMap(results);
    }

    public SortedMap<String, HealthCheck.Result> runHealthChecks(ExecutorService executor) {
        HashMap futures = new HashMap();
        for (final Map.Entry entry : this.healthChecks.entrySet()) {
            futures.put(entry.getKey(), executor.submit(new Callable<HealthCheck.Result>(){

                @Override
                public HealthCheck.Result call() throws Exception {
                    return ((HealthCheck)entry.getValue()).execute();
                }
            }));
        }
        TreeMap results = new TreeMap();
        for (Map.Entry entry : futures.entrySet()) {
            try {
                results.put(entry.getKey(), ((Future)entry.getValue()).get());
            }
            catch (Exception e) {
                LOGGER.warn("Error executing health check {}", entry.getKey(), (Object)e);
                results.put(entry.getKey(), HealthCheck.Result.unhealthy(e));
            }
        }
        return Collections.unmodifiableSortedMap(results);
    }

    private void onHealthCheckAdded(String name, HealthCheck healthCheck) {
        for (HealthCheckRegistryListener listener : this.listeners) {
            listener.onHealthCheckAdded(name, healthCheck);
        }
    }

    private void onHealthCheckRemoved(String name, HealthCheck healthCheck) {
        for (HealthCheckRegistryListener listener : this.listeners) {
            listener.onHealthCheckRemoved(name, healthCheck);
        }
    }

    private static ScheduledExecutorService createExecutorService(int corePoolSize) {
        ScheduledExecutorService asyncExecutorService = Executors.newScheduledThreadPool(corePoolSize, new NamedThreadFactory("healthcheck-async-executor-"));
        try {
            Method method = asyncExecutorService.getClass().getMethod("setRemoveOnCancelPolicy", Boolean.TYPE);
            method.invoke((Object)asyncExecutorService, true);
        }
        catch (NoSuchMethodException e) {
            HealthCheckRegistry.logSetExecutorCancellationPolicyFailure(e);
        }
        catch (IllegalAccessException e) {
            HealthCheckRegistry.logSetExecutorCancellationPolicyFailure(e);
        }
        catch (InvocationTargetException e) {
            HealthCheckRegistry.logSetExecutorCancellationPolicyFailure(e);
        }
        return asyncExecutorService;
    }

    private static void logSetExecutorCancellationPolicyFailure(Exception e) {
        LOGGER.warn("Tried but failed to set executor cancellation policy to remove on cancel which has been introduced in Java 7. This could result in a memory leak if many asynchronous health checks are registered and removed because cancellation does not actually remove them from the executor.", (Throwable)e);
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        NamedThreadFactory(String namePrefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

