/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jdbi3;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jdbi3.strategies.SmartNameStrategy;
import com.codahale.metrics.jdbi3.strategies.StatementNameStrategy;
import java.util.concurrent.TimeUnit;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.TimingCollector;

public class InstrumentedTimingCollector
implements TimingCollector {
    private final MetricRegistry registry;
    private final StatementNameStrategy statementNameStrategy;

    public InstrumentedTimingCollector(MetricRegistry registry) {
        this(registry, new SmartNameStrategy());
    }

    public InstrumentedTimingCollector(MetricRegistry registry, StatementNameStrategy statementNameStrategy) {
        this.registry = registry;
        this.statementNameStrategy = statementNameStrategy;
    }

    public void collect(long elapsedTime, StatementContext ctx) {
        String statementName = this.statementNameStrategy.getStatementName(ctx);
        if (statementName != null) {
            this.registry.timer(statementName).update(elapsedTime, TimeUnit.NANOSECONDS);
        }
    }
}

