/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jetty9;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.AsyncContextState;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class InstrumentedHandler
extends HandlerWrapper {
    private final MetricRegistry metricRegistry;
    private String name;
    private final String prefix;
    private Timer requests;
    private Timer dispatches;
    private Counter activeRequests;
    private Counter activeDispatches;
    private Counter activeSuspended;
    private Meter asyncDispatches;
    private Meter asyncTimeouts;
    private Meter[] responses;
    private Timer getRequests;
    private Timer postRequests;
    private Timer headRequests;
    private Timer putRequests;
    private Timer deleteRequests;
    private Timer optionsRequests;
    private Timer traceRequests;
    private Timer connectRequests;
    private Timer moveRequests;
    private Timer otherRequests;
    private AsyncListener listener;

    public InstrumentedHandler(MetricRegistry registry) {
        this(registry, null);
    }

    public InstrumentedHandler(MetricRegistry registry, String prefix) {
        this.metricRegistry = registry;
        this.prefix = prefix;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void doStart() throws Exception {
        super.doStart();
        String prefix = this.prefix == null ? MetricRegistry.name(this.getHandler().getClass(), (String[])new String[]{this.name}) : MetricRegistry.name((String)this.prefix, (String[])new String[]{this.name});
        this.requests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"requests"}));
        this.dispatches = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"dispatches"}));
        this.activeRequests = this.metricRegistry.counter(MetricRegistry.name((String)prefix, (String[])new String[]{"active-requests"}));
        this.activeDispatches = this.metricRegistry.counter(MetricRegistry.name((String)prefix, (String[])new String[]{"active-dispatches"}));
        this.activeSuspended = this.metricRegistry.counter(MetricRegistry.name((String)prefix, (String[])new String[]{"active-suspended"}));
        this.asyncDispatches = this.metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"async-dispatches"}));
        this.asyncTimeouts = this.metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"async-timeouts"}));
        this.responses = new Meter[]{this.metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"1xx-responses"})), this.metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"2xx-responses"})), this.metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"3xx-responses"})), this.metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"4xx-responses"})), this.metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"5xx-responses"}))};
        this.getRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"get-requests"}));
        this.postRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"post-requests"}));
        this.headRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"head-requests"}));
        this.putRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"put-requests"}));
        this.deleteRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"delete-requests"}));
        this.optionsRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"options-requests"}));
        this.traceRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"trace-requests"}));
        this.connectRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"connect-requests"}));
        this.moveRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"move-requests"}));
        this.otherRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{"other-requests"}));
        this.listener = new AsyncListener(){
            private long startTime;

            public void onTimeout(AsyncEvent event) throws IOException {
                InstrumentedHandler.this.asyncTimeouts.mark();
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
                this.startTime = System.currentTimeMillis();
                event.getAsyncContext().addListener((AsyncListener)this);
            }

            public void onError(AsyncEvent event) throws IOException {
            }

            public void onComplete(AsyncEvent event) throws IOException {
                AsyncContextState state = (AsyncContextState)event.getAsyncContext();
                HttpServletRequest request = (HttpServletRequest)state.getRequest();
                HttpServletResponse response = (HttpServletResponse)state.getResponse();
                InstrumentedHandler.this.updateResponses(request, response, this.startTime);
                if (state.getHttpChannelState().getState() != HttpChannelState.State.DISPATCHED) {
                    InstrumentedHandler.this.activeSuspended.dec();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        long start;
        this.activeDispatches.inc();
        HttpChannelState state = request.getHttpChannelState();
        if (state.isInitial()) {
            this.activeRequests.inc();
            start = request.getTimeStamp();
        } else {
            start = System.currentTimeMillis();
            this.activeSuspended.dec();
            if (state.getState() == HttpChannelState.State.DISPATCHED) {
                this.asyncDispatches.mark();
            }
        }
        try {
            super.handle(path, request, httpRequest, httpResponse);
        }
        finally {
            long now = System.currentTimeMillis();
            long dispatched = now - start;
            this.activeDispatches.dec();
            this.dispatches.update(dispatched, TimeUnit.MILLISECONDS);
            if (state.isSuspended()) {
                if (state.isInitial()) {
                    state.addListener(this.listener);
                }
                this.activeSuspended.inc();
            } else if (state.isInitial()) {
                this.updateResponses(httpRequest, httpResponse, start);
            }
        }
    }

    private Timer requestTimer(String method) {
        HttpMethod m = HttpMethod.fromString((String)method);
        if (m == null) {
            return this.otherRequests;
        }
        switch (m) {
            case GET: {
                return this.getRequests;
            }
            case POST: {
                return this.postRequests;
            }
            case PUT: {
                return this.putRequests;
            }
            case HEAD: {
                return this.headRequests;
            }
            case DELETE: {
                return this.deleteRequests;
            }
            case OPTIONS: {
                return this.optionsRequests;
            }
            case TRACE: {
                return this.traceRequests;
            }
            case CONNECT: {
                return this.connectRequests;
            }
            case MOVE: {
                return this.moveRequests;
            }
        }
        return this.otherRequests;
    }

    private void updateResponses(HttpServletRequest request, HttpServletResponse response, long start) {
        int responseStatus = response.getStatus() / 100;
        if (responseStatus >= 1 && responseStatus <= 5) {
            this.responses[responseStatus - 1].mark();
        }
        this.activeRequests.dec();
        long elapsedTime = System.currentTimeMillis() - start;
        this.requests.update(elapsedTime, TimeUnit.MILLISECONDS);
        this.requestTimer(request.getMethod()).update(elapsedTime, TimeUnit.MILLISECONDS);
    }
}

