/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.log4j2;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.io.Serializable;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="MetricsAppender", category="Core", elementType="appender")
public class InstrumentedAppender
extends AbstractAppender {
    private static final long serialVersionUID = 1L;
    private final transient MetricRegistry registry;
    private transient Meter all;
    private transient Meter trace;
    private transient Meter debug;
    private transient Meter info;
    private transient Meter warn;
    private transient Meter error;
    private transient Meter fatal;

    public InstrumentedAppender(String registryName, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        this(SharedMetricRegistries.getOrCreate((String)registryName), filter, layout, ignoreExceptions);
    }

    public InstrumentedAppender(String registryName) {
        this(SharedMetricRegistries.getOrCreate((String)registryName));
    }

    public InstrumentedAppender(MetricRegistry registry) {
        this(registry, null, null, true);
    }

    public InstrumentedAppender(MetricRegistry registry, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(MetricRegistry.name(Appender.class, (String[])new String[0]), filter, layout, ignoreExceptions);
        this.registry = registry;
    }

    public InstrumentedAppender(String appenderName, MetricRegistry registry) {
        super(appenderName, null, null, true);
        this.registry = registry;
    }

    @PluginFactory
    public static InstrumentedAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="registryName", defaultString="log4j2Metrics") String registry) {
        return new InstrumentedAppender(name, SharedMetricRegistries.getOrCreate((String)registry));
    }

    public void start() {
        this.all = this.registry.meter(MetricRegistry.name((String)this.getName(), (String[])new String[]{"all"}));
        this.trace = this.registry.meter(MetricRegistry.name((String)this.getName(), (String[])new String[]{"trace"}));
        this.debug = this.registry.meter(MetricRegistry.name((String)this.getName(), (String[])new String[]{"debug"}));
        this.info = this.registry.meter(MetricRegistry.name((String)this.getName(), (String[])new String[]{"info"}));
        this.warn = this.registry.meter(MetricRegistry.name((String)this.getName(), (String[])new String[]{"warn"}));
        this.error = this.registry.meter(MetricRegistry.name((String)this.getName(), (String[])new String[]{"error"}));
        this.fatal = this.registry.meter(MetricRegistry.name((String)this.getName(), (String[])new String[]{"fatal"}));
        super.start();
    }

    public void append(LogEvent event) {
        this.all.mark();
        switch (event.getLevel().getStandardLevel()) {
            case TRACE: {
                this.trace.mark();
                break;
            }
            case DEBUG: {
                this.debug.mark();
                break;
            }
            case INFO: {
                this.info.mark();
                break;
            }
            case WARN: {
                this.warn.mark();
                break;
            }
            case ERROR: {
                this.error.mark();
                break;
            }
            case FATAL: {
                this.fatal.mark();
                break;
            }
        }
    }
}

