/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.flyway.cli;

import io.dropwizard.core.Configuration;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.flyway.FlywayConfiguration;
import io.dropwizard.flyway.FlywayFactory;
import io.dropwizard.flyway.cli.AbstractFlywayCommand;
import io.dropwizard.flyway.cli.DbCleanCommand;
import io.dropwizard.flyway.cli.DbInfoCommand;
import io.dropwizard.flyway.cli.DbInitCommand;
import io.dropwizard.flyway.cli.DbMigrateCommand;
import io.dropwizard.flyway.cli.DbRepairCommand;
import io.dropwizard.flyway.cli.DbValidateCommand;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.flywaydb.core.Flyway;

public class DbCommand<T extends Configuration>
extends AbstractFlywayCommand<T> {
    private static final String COMMAND_NAME_ATTR = "subCommand";
    private final SortedMap<String, AbstractFlywayCommand<T>> subCommands = new TreeMap<String, AbstractFlywayCommand<T>>();

    public DbCommand(String name, DatabaseConfiguration<T> databaseConfiguration, FlywayConfiguration<T> flywayConfiguration, Class<T> configurationClass) {
        super(name, "Run database migration tasks", databaseConfiguration, flywayConfiguration, configurationClass);
        this.addSubCommand(new DbMigrateCommand<T>(databaseConfiguration, flywayConfiguration, configurationClass));
        this.addSubCommand(new DbCleanCommand<T>(databaseConfiguration, flywayConfiguration, configurationClass));
        this.addSubCommand(new DbInitCommand<T>(databaseConfiguration, flywayConfiguration, configurationClass));
        this.addSubCommand(new DbValidateCommand<T>(databaseConfiguration, flywayConfiguration, configurationClass));
        this.addSubCommand(new DbInfoCommand<T>(databaseConfiguration, flywayConfiguration, configurationClass));
        this.addSubCommand(new DbRepairCommand<T>(databaseConfiguration, flywayConfiguration, configurationClass));
    }

    private void addSubCommand(AbstractFlywayCommand<T> subCommand) {
        this.subCommands.put(subCommand.getName(), subCommand);
    }

    public void configure(Subparser subparser) {
        for (AbstractFlywayCommand<T> subCommand : this.subCommands.values()) {
            Subparser cmdParser = subparser.addSubparsers().addParser(subCommand.getName()).setDefault(COMMAND_NAME_ATTR, (Object)subCommand.getName()).description(subCommand.getDescription());
            subCommand.configure(cmdParser);
        }
    }

    @Override
    protected void setAdditionalOptions(FlywayFactory flywayFactory, Namespace namespace) {
        ((AbstractFlywayCommand)((Object)this.subCommands.get(namespace.getString(COMMAND_NAME_ATTR)))).setAdditionalOptions(flywayFactory, namespace);
    }

    @Override
    public void run(Namespace namespace, Flyway flyway) throws Exception {
        ((AbstractFlywayCommand)((Object)this.subCommands.get(namespace.getString(COMMAND_NAME_ATTR)))).run(namespace, flyway);
    }
}

