/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.flyway;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.database.oracle.OracleConfigurationExtension;

public class FlywayFactory {
    @JsonProperty
    @NotEmpty
    private String encoding = StandardCharsets.UTF_8.name();
    @JsonProperty
    private @Nullable String defaultSchema = null;
    @JsonProperty
    @NotNull
    private List<String> schemas = Collections.emptyList();
    @JsonProperty
    @NotNull
    private List<String> callbacks = Collections.emptyList();
    @JsonProperty
    @NotEmpty
    private String metaDataTableName = "flyway_schema_history";
    @JsonProperty
    @NotEmpty
    private String sqlMigrationPrefix = "V";
    @JsonProperty
    @NotEmpty
    private String sqlMigrationSeparator = "__";
    @JsonProperty
    @NotNull
    private List<String> sqlMigrationSuffixes = Collections.singletonList(".sql");
    @JsonProperty
    @NotEmpty
    private String placeholderPrefix = "${";
    @JsonProperty
    @NotEmpty
    private String placeholderSuffix = "}";
    @JsonProperty
    @NotNull
    private Map<String, String> placeholders = Collections.emptyMap();
    @JsonProperty
    @NotEmpty
    private List<String> locations = Collections.singletonList("db/migration");
    @JsonProperty
    @NotNull
    private List<String> resolvers = Collections.emptyList();
    @JsonProperty
    private String initSql = null;
    @JsonIgnore
    private ClassLoader classLoader = null;
    @JsonProperty
    private boolean outOfOrder = false;
    @JsonProperty
    @NotNull
    private String baselineDescription = "<< Flyway Baseline >>";
    @JsonProperty
    private boolean baselineOnMigrate = false;
    @JsonProperty
    private boolean validateOnMigrate = true;
    @JsonProperty
    @NotBlank
    private String baseLineVersion = "1";
    @JsonProperty
    private boolean cleanDisabled = false;
    @JsonProperty
    private boolean cleanOnValidationError = false;
    @JsonProperty
    private boolean group = false;
    @JsonProperty
    private List<String> ignoreMigrationPatterns = Collections.singletonList("*:future");
    @JsonProperty
    @NotNull
    private String installedBy = "";
    @JsonProperty
    private boolean mixed = false;
    @JsonProperty
    private boolean placeholderReplacement = true;
    @JsonProperty
    private boolean skipDefaultCallbacks = false;
    @JsonProperty
    private boolean skipDefaultResolvers = false;
    @JsonProperty
    private @Nullable Boolean batch;
    @JsonProperty
    private @Nullable File dryRunOutputFile;
    @JsonProperty
    private @Nullable List<String> errorOverrides;
    @JsonProperty
    private @Nullable Boolean oracleSqlPlus;
    @JsonProperty
    private @Nullable Boolean stream;
    @JsonProperty
    private @Nullable String target;
    @JsonProperty
    private @Nullable String undoSqlMigrationPrefix;
    @JsonProperty
    @Nullable Map<String, String> configuration = Collections.emptyMap();

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public @Nullable String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(@Nullable String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    public List<String> getCallbacks() {
        return this.callbacks;
    }

    public void setCallbacks(List<String> callbacks) {
        this.callbacks = callbacks;
    }

    public String getMetaDataTableName() {
        return this.metaDataTableName;
    }

    public void setMetaDataTableName(String metaDataTableName) {
        this.metaDataTableName = metaDataTableName;
    }

    public String getSqlMigrationPrefix() {
        return this.sqlMigrationPrefix;
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.sqlMigrationPrefix = sqlMigrationPrefix;
    }

    public List<String> getSqlMigrationSuffixes() {
        return this.sqlMigrationSuffixes;
    }

    public void setSqlMigrationSuffixes(List<String> sqlMigrationSuffixes) {
        this.sqlMigrationSuffixes = sqlMigrationSuffixes;
    }

    public String getSqlMigrationSeparator() {
        return this.sqlMigrationSeparator;
    }

    public void setSqlMigrationSeparator(String sqlMigrationSeparator) {
        this.sqlMigrationSeparator = sqlMigrationSeparator;
    }

    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public List<String> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(List<String> resolvers) {
        this.resolvers = resolvers;
    }

    public String getInitSql() {
        return this.initSql;
    }

    public void setInitSql(String initSql) {
        this.initSql = initSql;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isOutOfOrder() {
        return this.outOfOrder;
    }

    public void setOutOfOrder(boolean outOfOrder) {
        this.outOfOrder = outOfOrder;
    }

    public String getBaselineDescription() {
        return this.baselineDescription;
    }

    public void setBaselineDescription(String baselineDescription) {
        this.baselineDescription = baselineDescription;
    }

    public boolean isBaselineOnMigrate() {
        return this.baselineOnMigrate;
    }

    public void setBaselineOnMigrate(boolean baselineOnMigrate) {
        this.baselineOnMigrate = baselineOnMigrate;
    }

    public boolean isValidateOnMigrate() {
        return this.validateOnMigrate;
    }

    public void setValidateOnMigrate(boolean validateOnMigrate) {
        this.validateOnMigrate = validateOnMigrate;
    }

    public String getBaseLineVersion() {
        return this.baseLineVersion;
    }

    public void setBaseLineVersion(String baseLineVersion) {
        this.baseLineVersion = baseLineVersion;
    }

    public boolean isCleanDisabled() {
        return this.cleanDisabled;
    }

    public void setCleanDisabled(boolean cleanDisabled) {
        this.cleanDisabled = cleanDisabled;
    }

    public boolean isCleanOnValidationError() {
        return this.cleanOnValidationError;
    }

    public void setCleanOnValidationError(boolean cleanOnValidationError) {
        this.cleanOnValidationError = cleanOnValidationError;
    }

    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public List<String> getIgnoreMigrationPatterns() {
        return this.ignoreMigrationPatterns;
    }

    public void setIgnoreMigrationPatterns(List<String> ignoreMigrationPatterns) {
        this.ignoreMigrationPatterns = ignoreMigrationPatterns;
    }

    public String getInstalledBy() {
        return this.installedBy;
    }

    public void setInstalledBy(String installedBy) {
        this.installedBy = installedBy;
    }

    public boolean isMixed() {
        return this.mixed;
    }

    public void setMixed(boolean mixed) {
        this.mixed = mixed;
    }

    public boolean isPlaceholderReplacement() {
        return this.placeholderReplacement;
    }

    public void setPlaceholderReplacement(boolean placeholderReplacement) {
        this.placeholderReplacement = placeholderReplacement;
    }

    public boolean isSkipDefaultCallbacks() {
        return this.skipDefaultCallbacks;
    }

    public void setSkipDefaultCallbacks(boolean skipDefaultCallbacks) {
        this.skipDefaultCallbacks = skipDefaultCallbacks;
    }

    public boolean isSkipDefaultResolvers() {
        return this.skipDefaultResolvers;
    }

    public void setSkipDefaultResolvers(boolean skipDefaultResolvers) {
        this.skipDefaultResolvers = skipDefaultResolvers;
    }

    public @Nullable Boolean isBatch() {
        return this.batch;
    }

    public void setBatch(@Nullable Boolean batch) {
        this.batch = batch;
    }

    public @Nullable File getDryRunOutputFile() {
        return this.dryRunOutputFile;
    }

    public void setDryRunOutputFile(@Nullable File dryRunOutputFile) {
        this.dryRunOutputFile = dryRunOutputFile;
    }

    public @Nullable List<String> getErrorOverrides() {
        return this.errorOverrides;
    }

    public void setErrorOverrides(@Nullable List<String> errorOverrides) {
        this.errorOverrides = errorOverrides;
    }

    public @Nullable Boolean isOracleSqlPlus() {
        return this.oracleSqlPlus;
    }

    public void setOracleSqlPlus(@Nullable Boolean oracleSqlPlus) {
        this.oracleSqlPlus = oracleSqlPlus;
    }

    public @Nullable Boolean isStream() {
        return this.stream;
    }

    public void setStream(@Nullable Boolean stream) {
        this.stream = stream;
    }

    public @Nullable String getTarget() {
        return this.target;
    }

    public void setTarget(@Nullable String target) {
        this.target = target;
    }

    public @Nullable String getUndoSqlMigrationPrefix() {
        return this.undoSqlMigrationPrefix;
    }

    public void setUndoSqlMigrationPrefix(@Nullable String undoSqlMigrationPrefix) {
        this.undoSqlMigrationPrefix = undoSqlMigrationPrefix;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public Flyway build(String url, String user, String password) {
        return this.createConfiguration().dataSource(url, user, password).load();
    }

    public Flyway build(DataSource dataSource) {
        return this.createConfiguration().dataSource(dataSource).load();
    }

    private FluentConfiguration createConfiguration() {
        String[] emptyStringArray = new String[]{};
        FluentConfiguration flyway = this.classLoader == null ? Flyway.configure() : Flyway.configure((ClassLoader)this.classLoader);
        flyway = flyway.baselineOnMigrate(this.baselineOnMigrate).baselineVersion(this.baseLineVersion).callbacks(this.callbacks.toArray(emptyStringArray)).cleanDisabled(this.cleanDisabled).cleanOnValidationError(this.cleanOnValidationError).configuration(this.configuration).encoding(this.encoding).group(this.group).ignoreMigrationPatterns(this.ignoreMigrationPatterns.toArray(emptyStringArray)).installedBy(this.installedBy).locations(this.locations.toArray(emptyStringArray)).mixed(this.mixed).outOfOrder(this.outOfOrder).placeholderPrefix(this.placeholderPrefix).placeholderReplacement(this.placeholderReplacement).placeholderSuffix(this.placeholderSuffix).placeholders(this.placeholders).resolvers(this.resolvers.toArray(emptyStringArray)).initSql(this.initSql).schemas(this.schemas.toArray(emptyStringArray)).skipDefaultCallbacks(this.skipDefaultCallbacks).skipDefaultResolvers(this.skipDefaultResolvers).sqlMigrationPrefix(this.sqlMigrationPrefix).sqlMigrationSeparator(this.sqlMigrationSeparator).sqlMigrationSuffixes(this.sqlMigrationSuffixes.toArray(emptyStringArray)).table(this.metaDataTableName).validateOnMigrate(this.validateOnMigrate);
        if (this.defaultSchema != null) {
            flyway.defaultSchema(this.defaultSchema);
        }
        if (this.batch != null) {
            flyway.batch(this.batch.booleanValue());
        }
        if (this.dryRunOutputFile != null) {
            flyway.dryRunOutput(this.dryRunOutputFile);
        }
        if (this.errorOverrides != null) {
            flyway.errorOverrides(this.errorOverrides.toArray(emptyStringArray));
        }
        if (this.oracleSqlPlus != null) {
            OracleConfigurationExtension oracleConfigurationExtension = (OracleConfigurationExtension)flyway.getPluginRegister().getPlugin(OracleConfigurationExtension.class);
            oracleConfigurationExtension.setSqlplus(this.oracleSqlPlus);
        }
        if (this.stream != null) {
            flyway.stream(this.stream.booleanValue());
        }
        if (this.target != null) {
            flyway.target(this.target);
        }
        if (this.undoSqlMigrationPrefix != null) {
            flyway.undoSqlMigrationPrefix(this.undoSqlMigrationPrefix);
        }
        return flyway;
    }
}

