/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.flyway.cli;

import io.dropwizard.core.Configuration;
import io.dropwizard.core.cli.ConfiguredCommand;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.flyway.FlywayConfiguration;
import io.dropwizard.flyway.FlywayFactory;
import javax.sql.DataSource;
import net.sourceforge.argparse4j.inf.Namespace;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractFlywayCommand<T extends Configuration>
extends ConfiguredCommand<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFlywayCommand.class);
    private final DatabaseConfiguration<T> databaseConfiguration;
    private final FlywayConfiguration<T> flywayConfiguration;
    private final Class<T> configurationClass;

    AbstractFlywayCommand(String name, String description, DatabaseConfiguration<T> databaseConfiguration, FlywayConfiguration<T> flywayConfiguration, Class<T> configurationClass) {
        super(name, description);
        this.databaseConfiguration = databaseConfiguration;
        this.flywayConfiguration = flywayConfiguration;
        this.configurationClass = configurationClass;
    }

    protected Class<T> getConfigurationClass() {
        return this.configurationClass;
    }

    protected void run(Bootstrap<T> bootstrap, Namespace namespace, T configuration) throws Exception {
        PooledDataSourceFactory datasourceFactory = this.databaseConfiguration.getDataSourceFactory(configuration);
        FlywayFactory flywayFactory = this.flywayConfiguration.getFlywayFactory(configuration);
        this.setAdditionalOptions(flywayFactory, namespace);
        Flyway flyway = flywayFactory.build((DataSource)datasourceFactory.build(bootstrap.getMetricRegistry(), "Flyway"));
        try {
            this.run(namespace, flyway);
        }
        catch (FlywayException e) {
            LOG.error("Error while running database command", (Throwable)e);
            throw e;
        }
    }

    protected abstract void setAdditionalOptions(FlywayFactory var1, Namespace var2);

    protected abstract void run(Namespace var1, Flyway var2) throws Exception;
}

