/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health.conf;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.dropwizard.health.conf.HealthCheckConfiguration;
import io.dropwizard.health.conf.response.DefaultHealthServletFactory;
import io.dropwizard.health.conf.response.HealthServletFactory;
import io.dropwizard.util.Duration;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class HealthConfiguration {
    @Valid
    @NotNull
    @JsonProperty
    private List<HealthCheckConfiguration> healthChecks = Collections.emptyList();
    @JsonProperty
    private boolean initialOverallState = true;
    @JsonProperty
    private boolean delayedShutdownHandlerEnabled = true;
    @NotNull
    @JsonProperty
    private Duration shutdownWaitPeriod = Duration.seconds((long)15L);
    @NotNull
    @Size(min=1)
    @JsonProperty
    private @NotNull @Size(min=1) List<String> healthCheckUrlPaths = ImmutableList.of((Object)"/health-check");
    @Valid
    @JsonProperty(value="servlet")
    private HealthServletFactory servletFactory = new DefaultHealthServletFactory();

    public List<HealthCheckConfiguration> getHealthCheckConfigurations() {
        return this.healthChecks;
    }

    public void setHealthCheckConfigurations(List<HealthCheckConfiguration> healthChecks) {
        this.healthChecks = healthChecks;
    }

    public boolean isInitialOverallState() {
        return this.initialOverallState;
    }

    public void setInitialOverallState(boolean initialOverallState) {
        this.initialOverallState = initialOverallState;
    }

    public boolean isDelayedShutdownHandlerEnabled() {
        return this.delayedShutdownHandlerEnabled;
    }

    public void setDelayedShutdownHandlerEnabled(boolean delayedShutdownHandlerEnabled) {
        this.delayedShutdownHandlerEnabled = delayedShutdownHandlerEnabled;
    }

    public Duration getShutdownWaitPeriod() {
        return this.shutdownWaitPeriod;
    }

    public void setShutdownWaitPeriod(Duration shutdownWaitPeriod) {
        this.shutdownWaitPeriod = shutdownWaitPeriod;
    }

    public List<String> getHealthCheckUrlPaths() {
        return this.healthCheckUrlPaths;
    }

    public void setHealthCheckUrlPaths(List<String> healthCheckUrlPaths) {
        this.healthCheckUrlPaths = healthCheckUrlPaths;
    }

    public HealthServletFactory getServletFactory() {
        return this.servletFactory;
    }

    public void setServletFactory(HealthServletFactory servletFactory) {
        this.servletFactory = servletFactory;
    }
}

