/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health.conf.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.health.conf.response.HealthServletFactory;
import io.dropwizard.health.core.HealthCheckServlet;
import io.dropwizard.health.core.HealthStatusChecker;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServlet;

@JsonTypeName(value="default")
public class DefaultHealthServletFactory
implements HealthServletFactory {
    private static final String STATUS_TEMPLATE = "{\"status\": \"%s\"}";
    @JsonProperty
    private boolean cacheControlEnabled = true;
    @JsonProperty
    private String cacheControlValue = "no-store";
    @JsonProperty
    private String contentType = "application/json";
    @JsonProperty
    private String healthyValue = String.format("{\"status\": \"%s\"}", "healthy");
    @JsonProperty
    private String unhealthyValue = String.format("{\"status\": \"%s\"}", "unhealthy");

    public boolean isCacheControlEnabled() {
        return this.cacheControlEnabled;
    }

    public void setCacheControlEnabled(boolean cacheControlEnabled) {
        this.cacheControlEnabled = cacheControlEnabled;
    }

    public String getCacheControlValue() {
        return this.cacheControlValue;
    }

    public void setCacheControlValue(String cacheControlValue) {
        this.cacheControlValue = cacheControlValue;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getHealthyValue() {
        return this.healthyValue;
    }

    public void setHealthyValue(String healthyValue) {
        this.healthyValue = healthyValue;
    }

    public String getUnhealthyValue() {
        return this.unhealthyValue;
    }

    public void setUnhealthyValue(String unhealthyValue) {
        this.unhealthyValue = unhealthyValue;
    }

    @Override
    @Deprecated
    public HttpServlet build(AtomicBoolean isHealthy) {
        return new HealthCheckServlet(isHealthy, this.cacheControlEnabled, this.cacheControlValue, this.contentType, this.healthyValue, this.unhealthyValue);
    }

    @Override
    public HttpServlet build(HealthStatusChecker healthStatusChecker) {
        return new HealthCheckServlet(healthStatusChecker, this.cacheControlEnabled, this.cacheControlValue, this.contentType, this.healthyValue, this.unhealthyValue);
    }
}

