/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health.core;

import io.dropwizard.health.core.ScheduledHealthCheck;
import io.dropwizard.util.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckScheduler {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckScheduler.class);
    private final ScheduledExecutorService executorService;
    private final Map<String, ScheduledFuture> futures = new ConcurrentHashMap<String, ScheduledFuture>();

    public HealthCheckScheduler(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    void scheduleInitial(ScheduledHealthCheck check) {
        Duration interval = check.isHealthy() ? check.getSchedule().getCheckInterval() : check.getSchedule().getDowntimeInterval();
        this.schedule(check, check.getSchedule().getInitialDelay(), interval);
    }

    public void schedule(ScheduledHealthCheck check, boolean healthy) {
        this.unschedule(check.getName());
        Duration interval = healthy ? check.getSchedule().getCheckInterval() : check.getSchedule().getDowntimeInterval();
        this.schedule(check, interval, interval);
    }

    private void schedule(ScheduledHealthCheck check, Duration initialDelay, Duration delay) {
        ScheduledFuture<?> taskFuture = this.executorService.scheduleWithFixedDelay(check, initialDelay.toMilliseconds(), delay.toMilliseconds(), TimeUnit.MILLISECONDS);
        this.futures.put(check.getName(), taskFuture);
        log.debug("Scheduled check: check={}", (Object)check);
    }

    public void unschedule(String name) {
        ScheduledFuture taskFuture = this.futures.get(name);
        if (taskFuture != null) {
            taskFuture.cancel(true);
            this.futures.remove(name);
            log.debug("Unscheduled check: name={}", (Object)name);
        }
    }
}

