/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health.shutdown;

import io.dropwizard.health.shutdown.ShutdownNotifier;
import io.dropwizard.util.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedShutdownHandler
extends AbstractLifeCycle {
    private static final Logger log = LoggerFactory.getLogger(DelayedShutdownHandler.class);
    private final ShutdownNotifier shutdownNotifier;

    @Deprecated
    public DelayedShutdownHandler(AtomicBoolean healthy, Duration shutdownWaitPeriod) {
        this(new LegacyShutdownNotifier(healthy, shutdownWaitPeriod));
    }

    public DelayedShutdownHandler(ShutdownNotifier shutdownNotifier) {
        this.shutdownNotifier = shutdownNotifier;
    }

    public void register() {
        try {
            this.start();
            ShutdownThread.register((int)0, (LifeCycle[])new LifeCycle[]{this});
        }
        catch (Exception e) {
            log.error("failed setting up delayed shutdown handler", (Throwable)e);
            throw new IllegalStateException("failed setting up delayed shutdown handler", e);
        }
    }

    protected void doStop() throws Exception {
        this.shutdownNotifier.notifyShutdownStarted();
    }

    private static class LegacyShutdownNotifier
    implements ShutdownNotifier {
        private final AtomicBoolean healthy;
        private final Duration shutdownWaitPeriod;

        public LegacyShutdownNotifier(AtomicBoolean healthy, Duration shutdownWaitPeriod) {
            this.healthy = healthy;
            this.shutdownWaitPeriod = shutdownWaitPeriod;
        }

        @Override
        public void notifyShutdownStarted() throws InterruptedException {
            log.info("delayed shutdown: started (waiting {})", (Object)this.shutdownWaitPeriod);
            this.healthy.set(false);
            Thread.sleep(this.shutdownWaitPeriod.toMilliseconds());
            log.info("delayed shutdown: finished");
        }
    }
}

