/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health.core;

import com.codahale.metrics.InstrumentedScheduledExecutorService;
import com.codahale.metrics.InstrumentedThreadFactory;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistryListener;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.health.conf.HealthCheckConfiguration;
import io.dropwizard.health.conf.HealthConfiguration;
import io.dropwizard.health.core.HealthCheckConfigValidator;
import io.dropwizard.health.core.HealthCheckManager;
import io.dropwizard.health.core.HealthCheckScheduler;
import io.dropwizard.health.shutdown.DelayedShutdownHandler;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Duration;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HealthCheckBundle<C extends Configuration>
implements ConfiguredBundle<C> {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckBundle.class);
    private static final String DEFAULT_BASE_NAME = "health-check";
    private final String baseName;
    private final String name;

    public HealthCheckBundle() {
        this(null);
    }

    @Deprecated
    protected HealthCheckBundle(String name) {
        this.name = name;
        this.baseName = name != null ? "health-check-" + name : DEFAULT_BASE_NAME;
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(C configuration, Environment environment) {
        MetricRegistry metrics = environment.metrics();
        HealthConfiguration healthConfig = this.getHealthConfiguration(configuration);
        List<HealthCheckConfiguration> healthCheckConfigs = healthConfig.getHealthCheckConfigurations();
        ScheduledExecutorService scheduledHealthCheckExecutor = this.createScheduledExecutorForHealthChecks(healthCheckConfigs.size(), metrics, environment.lifecycle());
        HealthCheckScheduler scheduler = new HealthCheckScheduler(scheduledHealthCheckExecutor);
        HealthCheckManager healthCheckManager = this.createHealthCheckManager(healthCheckConfigs, scheduler, metrics, this.name, healthConfig.getShutdownWaitPeriod(), healthConfig.isInitialOverallState());
        healthCheckManager.initializeAppHealth();
        HttpServlet userProvidedServlet = this.createHealthCheckServlet(healthCheckManager.getIsAppHealthy());
        HttpServlet servlet = userProvidedServlet != null ? userProvidedServlet : healthConfig.getServletFactory().build(healthCheckManager);
        environment.servlets().addServlet(this.baseName + "-servlet", (Servlet)servlet).addMapping(healthConfig.getHealthCheckUrlPaths().toArray(new String[0]));
        environment.healthChecks().addListener((HealthCheckRegistryListener)healthCheckManager);
        environment.lifecycle().manage((Managed)new HealthCheckConfigValidator(healthCheckConfigs, environment.healthChecks()));
        Duration shutdownWaitPeriod = healthConfig.getShutdownWaitPeriod();
        if (healthConfig.isDelayedShutdownHandlerEnabled() && shutdownWaitPeriod.toMilliseconds() > 0L) {
            DelayedShutdownHandler shutdownHandler = new DelayedShutdownHandler(healthCheckManager);
            shutdownHandler.register();
        }
    }

    private ScheduledExecutorService createScheduledExecutorForHealthChecks(int numberOfScheduledHealthChecks, MetricRegistry metrics, LifecycleEnvironment lifecycle) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(this.baseName + "-%d").setDaemon(true).setUncaughtExceptionHandler((t, e) -> log.error("Thread={} died due to uncaught exception", (Object)t, (Object)e)).build();
        InstrumentedThreadFactory instrumentedThreadFactory = new InstrumentedThreadFactory(threadFactory, metrics);
        ScheduledExecutorService scheduledExecutorService = lifecycle.scheduledExecutorService(this.baseName + "-scheduled-executor", (ThreadFactory)instrumentedThreadFactory).threads(numberOfScheduledHealthChecks).build();
        return new InstrumentedScheduledExecutorService(scheduledExecutorService, metrics);
    }

    protected HttpServlet createHealthCheckServlet(AtomicBoolean isHealthy) {
        return null;
    }

    @Deprecated
    protected HealthCheckManager createHealthCheckManager(List<HealthCheckConfiguration> healthCheckConfigs, HealthCheckScheduler scheduler, MetricRegistry metrics) {
        return this.createHealthCheckManager(healthCheckConfigs, scheduler, metrics, null);
    }

    @Deprecated
    protected HealthCheckManager createHealthCheckManager(List<HealthCheckConfiguration> healthCheckConfigs, HealthCheckScheduler scheduler, MetricRegistry metrics, String name) {
        return new HealthCheckManager(healthCheckConfigs, scheduler, metrics, name);
    }

    @Deprecated
    protected HealthCheckManager createHealthCheckManager(List<HealthCheckConfiguration> healthCheckConfigs, HealthCheckScheduler scheduler, MetricRegistry metrics, String name, Duration shutdownWaitPeriod, boolean initialOverallState) {
        return new HealthCheckManager(healthCheckConfigs, scheduler, metrics, name, shutdownWaitPeriod, initialOverallState);
    }

    protected abstract HealthConfiguration getHealthConfiguration(C var1);
}

