/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health.core;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistryListener;
import io.dropwizard.health.conf.HealthCheckConfiguration;
import io.dropwizard.health.conf.HealthCheckType;
import io.dropwizard.health.conf.Schedule;
import io.dropwizard.health.core.HealthCheckScheduler;
import io.dropwizard.health.core.HealthStatusChecker;
import io.dropwizard.health.core.ScheduledHealthCheck;
import io.dropwizard.health.core.State;
import io.dropwizard.health.core.StateChangedCallback;
import io.dropwizard.health.shutdown.ShutdownNotifier;
import io.dropwizard.util.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckManager
implements HealthCheckRegistryListener,
StateChangedCallback,
HealthStatusChecker,
ShutdownNotifier {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckManager.class);
    private static final Duration DEFAULT_SHUTDOWN_WAIT_PERIOD = Duration.seconds((long)15L);
    private static final boolean DEFAULT_INITIAL_OVERALL_STATE = true;
    private final AtomicBoolean isAppAlive = new AtomicBoolean(true);
    private final AtomicBoolean isAppHealthy = new AtomicBoolean(false);
    private final AtomicInteger unhealthyCriticalHealthChecks = new AtomicInteger();
    private final AtomicInteger unhealthyCriticalAliveChecks = new AtomicInteger();
    private final HealthCheckScheduler scheduler;
    private final Map<String, ScheduledHealthCheck> checks;
    private final Map<String, HealthCheckConfiguration> configs;
    private final MetricRegistry metrics;
    private final String managerName;
    private final Duration shutdownWaitPeriod;
    private final boolean initialOverallState;
    private final String aggregateHealthyName;
    private final String aggregateUnhealthyName;
    private volatile boolean shuttingDown = false;

    @Deprecated
    public HealthCheckManager(List<HealthCheckConfiguration> configs, HealthCheckScheduler scheduler, MetricRegistry metrics) {
        this(configs, scheduler, metrics, DEFAULT_SHUTDOWN_WAIT_PERIOD, true);
    }

    public HealthCheckManager(List<HealthCheckConfiguration> configs, HealthCheckScheduler scheduler, MetricRegistry metrics, Duration shutdownWaitPeriod, boolean initialOverallState) {
        this(configs, scheduler, metrics, null, shutdownWaitPeriod, initialOverallState);
    }

    @Deprecated
    public HealthCheckManager(List<HealthCheckConfiguration> configs, HealthCheckScheduler scheduler, MetricRegistry metrics, String managerName) {
        this(configs, scheduler, metrics, managerName, DEFAULT_SHUTDOWN_WAIT_PERIOD, true);
    }

    @Deprecated
    public HealthCheckManager(List<HealthCheckConfiguration> configs, HealthCheckScheduler scheduler, MetricRegistry metrics, String managerName, Duration shutdownWaitPeriod, boolean initialOverallState) {
        this(configs, scheduler, metrics, managerName, shutdownWaitPeriod, initialOverallState, new HashMap<String, ScheduledHealthCheck>());
    }

    HealthCheckManager(List<HealthCheckConfiguration> configs, HealthCheckScheduler scheduler, MetricRegistry metrics, String managerName, Duration shutdownWaitPeriod, boolean initialOverallState, Map<String, ScheduledHealthCheck> checks) {
        this.configs = configs.stream().collect(Collectors.toMap(HealthCheckConfiguration::getName, Function.identity()));
        this.scheduler = Objects.requireNonNull(scheduler);
        this.metrics = Objects.requireNonNull(metrics);
        this.managerName = managerName;
        this.shutdownWaitPeriod = shutdownWaitPeriod;
        this.initialOverallState = initialOverallState;
        this.checks = Objects.requireNonNull(checks);
        this.aggregateHealthyName = MetricRegistry.name((String)"health", (String[])new String[]{managerName, "aggregate", "healthy"});
        this.aggregateUnhealthyName = MetricRegistry.name((String)"health", (String[])new String[]{managerName, "aggregate", "unhealthy"});
        metrics.register(this.aggregateHealthyName, (Metric)((Gauge)this::calculateNumberOfHealthyChecks));
        metrics.register(this.aggregateUnhealthyName, (Metric)((Gauge)this::calculateNumberOfUnhealthyChecks));
    }

    public void onHealthCheckAdded(String name, HealthCheck healthCheck) {
        HealthCheckConfiguration config = this.configs.get(name);
        if (config == null) {
            log.debug("ignoring registered health check that isn't configured: name={}", (Object)name);
            return;
        }
        Schedule schedule = config.getSchedule();
        HealthCheckType type = config.getType();
        boolean critical = type == HealthCheckType.ALIVE || config.isCritical();
        boolean initialState = config.isInitialState();
        State state = new State(name, schedule.getFailureAttempts(), schedule.getSuccessAttempts(), initialState, this);
        Counter healthyCheckCounter = this.metrics.counter(MetricRegistry.name((String)"health", (String[])new String[]{this.managerName, name, "healthy"}));
        Counter unhealthyCheckCounter = this.metrics.counter(MetricRegistry.name((String)"health", (String[])new String[]{this.managerName, name, "unhealthy"}));
        ScheduledHealthCheck check = new ScheduledHealthCheck(name, type, critical, healthCheck, schedule, state, healthyCheckCounter, unhealthyCheckCounter);
        this.checks.put(name, check);
        if (!initialState && critical) {
            this.handleCriticalHealthChange(name, type, false);
        }
        this.scheduler.scheduleInitial(check);
    }

    public void onHealthCheckRemoved(String name, HealthCheck healthCheck) {
        this.scheduler.unschedule(name);
    }

    @Override
    public void onStateChanged(String name, boolean isNowHealthy) {
        log.debug("health check changed state: name={} state={}", (Object)name, (Object)isNowHealthy);
        ScheduledHealthCheck check = this.checks.get(name);
        if (check == null) {
            log.error("State changed for unconfigured health check: name={} state={}", (Object)name, (Object)isNowHealthy);
            return;
        }
        if (check.isCritical()) {
            this.handleCriticalHealthChange(check.getName(), check.getType(), isNowHealthy);
        } else {
            this.handleNonCriticalHealthChange(check.getName(), check.getType(), isNowHealthy);
        }
        this.scheduler.schedule(check, isNowHealthy);
    }

    protected void initializeAppHealth() {
        this.isAppHealthy.set(this.initialOverallState);
    }

    private long calculateNumberOfHealthyChecks() {
        return this.checks.values().stream().filter(ScheduledHealthCheck::isHealthy).count();
    }

    private long calculateNumberOfUnhealthyChecks() {
        return this.checks.values().stream().filter(check -> !check.isHealthy()).count();
    }

    private void handleCriticalHealthChange(String name, HealthCheckType type, boolean isNowHealthy) {
        if (isNowHealthy) {
            log.info("A critical dependency is now healthy: name={}, type={}", (Object)name, (Object)type);
            switch (type) {
                case ALIVE: {
                    this.updateCriticalStatus(this.isAppAlive, this.unhealthyCriticalAliveChecks.decrementAndGet());
                    return;
                }
                case READY: {
                    if (!this.shuttingDown) {
                        this.updateCriticalStatus(this.isAppHealthy, this.unhealthyCriticalHealthChecks.decrementAndGet());
                    } else {
                        log.info("Status change is ignored during shutdown: name={}, type={}", (Object)name, (Object)type);
                    }
                    return;
                }
            }
        } else {
            log.error("A critical dependency is now unhealthy: name={}, type={}", (Object)name, (Object)type);
            switch (type) {
                case ALIVE: {
                    this.updateCriticalStatus(this.isAppAlive, this.unhealthyCriticalAliveChecks.incrementAndGet());
                    return;
                }
                case READY: {
                    this.updateCriticalStatus(this.isAppHealthy, this.unhealthyCriticalHealthChecks.incrementAndGet());
                    return;
                }
            }
        }
        log.warn("Unexpected health check type: type={}", (Object)type);
    }

    private void updateCriticalStatus(AtomicBoolean status, int count) {
        status.set(count == 0);
        log.debug("current status: unhealthy-critical={}", (Object)count);
    }

    private void handleNonCriticalHealthChange(String name, HealthCheckType type, boolean isNowHealthy) {
        if (isNowHealthy) {
            log.info("A non-critical dependency is now healthy: name={}, type={}", (Object)name, (Object)type);
        } else {
            log.warn("A non-critical dependency is now unhealthy: name={}, type={}", (Object)name, (Object)type);
        }
    }

    @Deprecated
    public AtomicBoolean getIsAppHealthy() {
        return this.isAppHealthy;
    }

    String getAggregateHealthyName() {
        return this.aggregateHealthyName;
    }

    String getAggregateUnhealthyName() {
        return this.aggregateUnhealthyName;
    }

    @Override
    public boolean isHealthy() {
        return this.isAppAlive.get() && this.isAppHealthy.get();
    }

    @Override
    public boolean isHealthy(String type) {
        if (HealthCheckType.ALIVE.name().equalsIgnoreCase(type)) {
            return this.isAppAlive.get();
        }
        return this.isHealthy();
    }

    @Override
    public void notifyShutdownStarted() throws Exception {
        this.shuttingDown = true;
        log.info("delayed shutdown: started (waiting {})", (Object)this.shutdownWaitPeriod);
        this.isAppHealthy.set(false);
        Thread.sleep(this.shutdownWaitPeriod.toMilliseconds());
        log.info("delayed shutdown: finished");
    }
}

