/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health.core;

import io.dropwizard.health.core.HealthStatusChecker;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HealthCheckServlet
extends HttpServlet {
    private static final String CHECK_TYPE_QUERY_PARAM = "type";
    private final HealthStatusChecker healthStatusChecker;
    private final boolean cacheControlEnabled;
    private final String cacheControlValue;
    private final String contentType;
    private final String healthyValue;
    private final String unhealthyValue;

    @Deprecated
    public HealthCheckServlet(AtomicBoolean healthy, boolean cacheControlEnabled, String cacheControlValue, String contentType, String healthyValue, String unhealthyValue) {
        this(new LegacyHealthStatusChecker(healthy), cacheControlEnabled, cacheControlValue, contentType, healthyValue, unhealthyValue);
    }

    public HealthCheckServlet(HealthStatusChecker healthStatusChecker, boolean cacheControlEnabled, String cacheControlValue, String contentType, String healthyValue, String unhealthyValue) {
        this.healthStatusChecker = Objects.requireNonNull(healthStatusChecker);
        this.cacheControlEnabled = cacheControlEnabled;
        this.cacheControlValue = Objects.requireNonNull(cacheControlValue);
        this.contentType = Objects.requireNonNull(contentType);
        this.healthyValue = Objects.requireNonNull(healthyValue);
        this.unhealthyValue = Objects.requireNonNull(unhealthyValue);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.cacheControlEnabled) {
            resp.setHeader("Cache-Control", this.cacheControlValue);
        }
        resp.setContentType(this.contentType);
        String typeValue = req.getParameter(CHECK_TYPE_QUERY_PARAM);
        PrintWriter writer = resp.getWriter();
        if (this.healthStatusChecker.isHealthy(typeValue)) {
            writer.print(this.healthyValue);
        } else {
            writer.print(this.unhealthyValue);
            resp.setStatus(503);
        }
    }

    private static class LegacyHealthStatusChecker
    implements HealthStatusChecker {
        private final AtomicBoolean healthy;

        public LegacyHealthStatusChecker(AtomicBoolean healthy) {
            this.healthy = healthy;
        }

        @Override
        public boolean isHealthy(String type) {
            return this.healthy.get();
        }
    }
}

