/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health.core;

import io.dropwizard.health.core.StateChangedCallback;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class State {
    private static final Logger log = LoggerFactory.getLogger(State.class);
    private final String name;
    private final int successAttempts;
    private final int failureAttempts;
    private final StateChangedCallback stateChangedCallback;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final AtomicBoolean healthy;

    State(String name, int failureAttempts, int successAttempts, boolean initialState, StateChangedCallback stateChangedCallback) {
        this.name = name;
        this.failureAttempts = failureAttempts;
        this.successAttempts = successAttempts;
        this.healthy = new AtomicBoolean(initialState);
        this.stateChangedCallback = stateChangedCallback;
    }

    void success() {
        if (this.healthy.get()) {
            return;
        }
        log.trace("health check received a successful result: name={} current={}", (Object)this.name, (Object)this.healthy);
        this.handleEvent(this.successAttempts, true);
    }

    void failure() {
        if (!this.healthy.get()) {
            return;
        }
        log.trace("health check received a failed result: name={} current={}", (Object)this.name, (Object)this.healthy);
        this.handleEvent(this.failureAttempts, false);
    }

    private void handleEvent(int numAttempts, boolean result) {
        int newCount = this.counter.incrementAndGet();
        log.debug("health check state update: name={} result={} count={}/{}", new Object[]{this.name, result, newCount, numAttempts});
        if (newCount >= numAttempts) {
            boolean newState = !this.healthy.get();
            this.healthy.set(newState);
            this.resetCount();
            this.stateChangedCallback.onStateChanged(this.name, newState);
        }
    }

    private void resetCount() {
        this.counter.set(0);
    }

    AtomicBoolean getHealthy() {
        return this.healthy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof State)) {
            return false;
        }
        State state = (State)o;
        return this.successAttempts == state.successAttempts && this.failureAttempts == state.failureAttempts && Objects.equals(this.name, state.name) && Objects.equals(this.stateChangedCallback, state.stateChangedCallback) && Objects.equals(this.counter, state.counter) && Objects.equals(this.healthy, state.healthy);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.successAttempts, this.failureAttempts, this.stateChangedCallback, this.counter, this.healthy);
    }
}

