/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

public class JodaDateTimeMapper
implements ResultColumnMapper<DateTime> {
    private Optional<Calendar> calendar;

    public JodaDateTimeMapper() {
        this.calendar = Optional.empty();
    }

    public JodaDateTimeMapper(Optional<TimeZone> timeZone) {
        this.calendar = timeZone.map(GregorianCalendar::new);
    }

    private Optional<Calendar> cloneCalendar() {
        return this.calendar.map(Calendar::clone).map(x -> (Calendar)x);
    }

    @Nullable
    public DateTime mapColumn(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        Timestamp timestamp;
        Optional<Calendar> instance = this.cloneCalendar();
        Timestamp timestamp2 = timestamp = instance.isPresent() ? r.getTimestamp(columnNumber, instance.get()) : r.getTimestamp(columnNumber);
        if (timestamp == null) {
            return null;
        }
        return new DateTime(timestamp.getTime());
    }

    @Nullable
    public DateTime mapColumn(ResultSet r, String columnLabel, StatementContext ctx) throws SQLException {
        Timestamp timestamp;
        Optional<Calendar> instance = this.cloneCalendar();
        Timestamp timestamp2 = timestamp = instance.isPresent() ? r.getTimestamp(columnLabel, instance.get()) : r.getTimestamp(columnLabel);
        if (timestamp == null) {
            return null;
        }
        return new DateTime(timestamp.getTime());
    }
}

