/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import io.dropwizard.jdbi.args.LocalDateArgument;
import java.time.LocalDate;
import java.util.Optional;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class OptionalLocalDateArgumentFactory
implements ArgumentFactory<Optional<LocalDate>> {
    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        if (value instanceof Optional) {
            Optional optionalValue = (Optional)value;
            return optionalValue.isPresent() && optionalValue.get() instanceof LocalDate;
        }
        return false;
    }

    public Argument build(Class<?> expectedType, Optional<LocalDate> value, StatementContext ctx) {
        return new LocalDateArgument(value.orElse(null));
    }
}

