/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import io.dropwizard.jdbi.args.ZonedDateTimeArgument;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.TimeZone;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class OptionalZonedDateTimeArgumentFactory
implements ArgumentFactory<Optional<ZonedDateTime>> {
    private final Optional<Calendar> calendar;

    public OptionalZonedDateTimeArgumentFactory() {
        this.calendar = Optional.empty();
    }

    public OptionalZonedDateTimeArgumentFactory(Optional<TimeZone> timeZone) {
        this.calendar = timeZone.map(GregorianCalendar::new);
    }

    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        if (value instanceof Optional) {
            Optional optionalValue = (Optional)value;
            return optionalValue.isPresent() && optionalValue.get() instanceof ZonedDateTime;
        }
        return false;
    }

    public Argument build(Class<?> expectedType, Optional<ZonedDateTime> value, StatementContext ctx) {
        return new ZonedDateTimeArgument(value.orElse(null), this.calendar);
    }
}

