/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka;

import com.codahale.metrics.health.HealthCheckRegistry;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.kafka.KafkaAdminClientFactory;
import io.dropwizard.kafka.KafkaTopicFactory;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.validation.ValidationMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="basic")
public class BasicKafkaAdminClientFactory
extends KafkaAdminClientFactory {
    private static final Logger log = LoggerFactory.getLogger(BasicKafkaAdminClientFactory.class);

    @Override
    public AdminClient build(LifecycleEnvironment lifecycle, HealthCheckRegistry healthChecks, Map<String, Object> configOverrides, Collection<NewTopic> topics) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", String.join((CharSequence)",", this.bootstrapServers));
        config.put("client.id", this.clientId);
        config.put("client.dns.lookup", this.clientDnsLookup.toString());
        config.put("reconnect.backoff.ms", this.reconnectBackoff.toMilliseconds());
        config.put("reconnect.backoff.max.ms", this.reconnectBackoffMax.toMilliseconds());
        config.put("retries", this.retries);
        config.put("retry.backoff.ms", this.retryBackoff.toMilliseconds());
        config.put("connections.max.idle.ms", this.connectionMaxIdle.toMilliseconds());
        config.put("request.timeout.ms", (int)this.requestTimeout.toMilliseconds());
        config.put("metadata.max.age.ms", this.metadataMaxAge.toMilliseconds());
        config.put("send.buffer.bytes", this.sendBufferBytes);
        config.put("receive.buffer.bytes", this.receiveBufferBytes);
        config.put("metric.reporters", this.metricsReporters);
        config.put("metrics.num.samples", this.metricsSamples);
        config.put("metrics.sample.window.ms", this.metricsSampleWindow.toMilliseconds());
        config.put("metrics.recording.level", this.metricsRecordingLevel.toString());
        if (this.security != null && this.security.isEnabled()) {
            config.putAll(this.security.build());
        }
        if (!Objects.requireNonNull(configOverrides).isEmpty()) {
            config.putAll(configOverrides);
        }
        AdminClient adminClient = this.buildAdminClient(config);
        this.manageAdminClient(lifecycle, adminClient, topics);
        this.registerHealthCheck(healthChecks, adminClient);
        return adminClient;
    }

    @Override
    public AdminClient build(LifecycleEnvironment lifecycle, HealthCheckRegistry healthChecks, Map<String, Object> configOverrides) {
        List<Object> newTopics = Collections.emptyList();
        if (this.topicCreationEnabled) {
            newTopics = this.topics.stream().map(KafkaTopicFactory::asNewTopic).collect(Collectors.toList());
        }
        return this.build(lifecycle, healthChecks, configOverrides, newTopics);
    }

    @ValidationMethod(message="Bootstrap servers must not be empty in BasicKafkaAdminClientFactory and topics must be defined if allowed to be created")
    public boolean isValidConfiguration() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.bootstrapServers.isEmpty()) {
            errors.add("bootstrapServers cannot be empty if basic type is configured");
        }
        if (this.topicCreationEnabled && this.topics.isEmpty()) {
            errors.add("topicCreationEnabled cannot be true with no topics defined");
        }
        if (!this.topicCreationEnabled && !this.topics.isEmpty()) {
            log.warn("topicCreationEnabled was set to false, but topics were defined");
        }
        if (!errors.isEmpty()) {
            String errorMessage = String.join((CharSequence)System.lineSeparator(), errors);
            log.error("Failed to construct a basic Kafka cluster connection, due to the following errors:{}{}", (Object)System.lineSeparator(), (Object)errorMessage);
            return false;
        }
        return true;
    }
}

