/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka;

import brave.Tracing;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.kafka.KafkaConsumerFactory;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="basic")
public class BasicKafkaConsumerFactory<K, V>
extends KafkaConsumerFactory<K, V> {
    private static final Logger log = LoggerFactory.getLogger(BasicKafkaConsumerFactory.class);

    @Override
    public Consumer<K, V> build(LifecycleEnvironment lifecycle, HealthCheckRegistry healthChecks, @Nullable Tracing tracing, @Nullable ConsumerRebalanceListener rebalanceListener, Map<String, Object> configOverrides) {
        Map<String, Object> config = this.createBaseKafkaConfigurations();
        config.put("bootstrap.servers", String.join((CharSequence)",", this.bootstrapServers));
        config.put("group.id", this.consumerGroupId);
        if (!Objects.requireNonNull(configOverrides).isEmpty()) {
            config.putAll(configOverrides);
        }
        Optional<Consumer> kafkaTracing = Optional.ofNullable(this.getTracingFactory()).flatMap(tracingFactory -> tracingFactory.build(tracing));
        Consumer rawConsumer = this.buildConsumer(config);
        Consumer consumer = kafkaTracing.map(kTracing -> kTracing.consumer(rawConsumer)).orElse(rawConsumer);
        this.manageConsumer(lifecycle, consumer);
        this.registerHealthCheck(healthChecks, consumer);
        return consumer;
    }

    @Override
    public boolean isValidConfiguration() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.bootstrapServers != null && this.bootstrapServers.isEmpty()) {
            errors.add("bootstrapServers cannot be empty if basic type is configured");
        }
        if (!errors.isEmpty()) {
            String errorMessage = String.join((CharSequence)System.lineSeparator(), errors);
            log.error("Failed to construct a BASIC Kafka cluster connection, due to the following errors:{}{}", (Object)System.lineSeparator(), (Object)errorMessage);
            return false;
        }
        return true;
    }
}

