/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka;

import brave.Tracing;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.kafka.KafkaProducerFactory;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="basic")
public class BasicKafkaProducerFactory<K, V>
extends KafkaProducerFactory<K, V> {
    private static final Logger log = LoggerFactory.getLogger(BasicKafkaProducerFactory.class);

    @Override
    public Producer<K, V> build(LifecycleEnvironment lifecycle, HealthCheckRegistry healthChecks, Collection<String> topics, @Nullable Tracing tracing, Map<String, Object> configOverrides) {
        Map<String, Object> config = this.createBaseKafkaConfigurations();
        config.put("bootstrap.servers", String.join((CharSequence)",", this.bootstrapServers));
        if (!Objects.requireNonNull(configOverrides).isEmpty()) {
            config.putAll(configOverrides);
        }
        Optional<Producer> kafkaTracing = Optional.ofNullable(this.getTracingFactory()).flatMap(tracingFactory -> tracingFactory.build(tracing));
        Producer rawProducer = this.buildProducer(config);
        Producer producer = kafkaTracing.map(kTracing -> kTracing.producer(rawProducer)).orElse(rawProducer);
        this.manageProducer(lifecycle, producer);
        this.registerProducerHealthCheck(healthChecks, producer, topics);
        return producer;
    }

    @Override
    public boolean isValidConfiguration() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.bootstrapServers != null && this.bootstrapServers.isEmpty()) {
            errors.add("bootstrapServers cannot be empty if basic type is configured");
        }
        if (!errors.isEmpty()) {
            String errorMessage = String.join((CharSequence)System.lineSeparator(), errors);
            log.error("Failed to construct a basic Kafka cluster connection, due to the following errors:{}{}", (Object)System.lineSeparator(), (Object)errorMessage);
            return false;
        }
        return true;
    }
}

