/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardKafkaUtils {
    private static final Logger log = LoggerFactory.getLogger(DropwizardKafkaUtils.class);

    private DropwizardKafkaUtils() {
    }

    public static void validateStringIsValidSubClass(String classString, Class<?> parentClass) {
        Class<?> actualClass;
        try {
            actualClass = Class.forName(classString);
        }
        catch (ClassNotFoundException e) {
            log.error("No valid class found for string={}", (Object)classString);
            throw new RuntimeException(e);
        }
        if (!parentClass.isAssignableFrom(actualClass)) {
            log.error("class={} is not a subclass of parentClass={}", actualClass, parentClass);
            throw new IllegalStateException(String.format("Class for name=%s is not a child of parentClass=%s", actualClass, parentClass));
        }
    }
}

