/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka;

import brave.Tracing;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.kafka.KafkaAdminClientFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;

public abstract class KafkaAdminClientBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private final Collection<NewTopic> topics;
    private final Map<String, Object> configOverrides;
    @Nullable
    private AdminClient adminClient;

    protected KafkaAdminClientBundle(Collection<NewTopic> topics) {
        this(topics, Collections.emptyMap());
    }

    public KafkaAdminClientBundle(Map<String, Object> configOverrides) {
        this(Collections.emptyList(), configOverrides);
    }

    protected KafkaAdminClientBundle(Collection<NewTopic> topics, Map<String, Object> configOverrides) {
        this.topics = Objects.requireNonNull(topics);
        this.configOverrides = Objects.requireNonNull(configOverrides);
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) throws Exception {
        KafkaAdminClientFactory kafkaAdminClientFactory = Objects.requireNonNull(this.getKafkaAdminClientFactory(configuration));
        Tracing tracing = Tracing.current();
        this.adminClient = kafkaAdminClientFactory.build(environment.lifecycle(), environment.healthChecks(), this.configOverrides, this.topics);
    }

    public abstract KafkaAdminClientFactory getKafkaAdminClientFactory(T var1);

    public AdminClient getAdminClient() {
        return Objects.requireNonNull(this.adminClient);
    }
}

