/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.dropwizard.kafka.KafkaTopicFactory;
import io.dropwizard.kafka.health.KafkaAdminHealthCheck;
import io.dropwizard.kafka.managed.KafkaAdminClientManager;
import io.dropwizard.kafka.metrics.DropwizardMetricsReporter;
import io.dropwizard.kafka.security.SecurityFactory;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.util.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public abstract class KafkaAdminClientFactory {
    @NotNull
    @JsonProperty
    protected String name;
    @NotNull
    @JsonProperty
    protected String clientId;
    @NotNull
    @JsonProperty
    protected Set<String> bootstrapServers = Collections.emptySet();
    @NotNull
    @JsonProperty
    protected ClientDnsLookup clientDnsLookup = ClientDnsLookup.USE_ALL_DNS_IPS;
    @NotNull
    @JsonProperty
    protected Duration reconnectBackoff = Duration.milliseconds((long)50L);
    @NotNull
    @JsonProperty
    protected Duration reconnectBackoffMax = Duration.seconds((long)1L);
    @Min(value=0L)
    @NotNull
    @JsonProperty
    protected @Min(value=0L) @NotNull Integer retries = 5;
    @NotNull
    @JsonProperty
    protected Duration retryBackoff = Duration.milliseconds((long)100L);
    @NotNull
    @JsonProperty
    protected Duration connectionMaxIdle = Duration.minutes((long)5L);
    @NotNull
    @JsonProperty
    protected Duration requestTimeout = Duration.minutes((long)2L);
    @NotNull
    @JsonProperty
    protected Duration metadataMaxAge = Duration.minutes((long)5L);
    @Min(value=-1L)
    @NotNull
    @JsonProperty
    protected @Min(value=-1L) @NotNull Integer sendBufferBytes = 131072;
    @Min(value=-1L)
    @NotNull
    @JsonProperty
    protected @Min(value=-1L) @NotNull Integer receiveBufferBytes = 65536;
    @NotNull
    @JsonProperty
    protected List<Class<? extends MetricsReporter>> metricsReporters = Collections.singletonList(DropwizardMetricsReporter.class);
    @Min(value=1L)
    @NotNull
    @JsonProperty
    protected @Min(value=1L) @NotNull Integer metricsSamples = 2;
    @NotNull
    @JsonProperty
    protected Duration metricsSampleWindow = Duration.seconds((long)30L);
    @NotNull
    @JsonProperty
    protected Sensor.RecordingLevel metricsRecordingLevel = Sensor.RecordingLevel.INFO;
    @Valid
    @JsonProperty
    protected SecurityFactory security;
    @JsonProperty
    protected boolean topicCreationEnabled = false;
    @Valid
    @NotNull
    @JsonProperty
    protected Set<KafkaTopicFactory> topics = Collections.emptySet();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Set<String> getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(Set<String> bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public ClientDnsLookup getClientDnsLookup() {
        return this.clientDnsLookup;
    }

    public void setClientDnsLookup(ClientDnsLookup clientDnsLookup) {
        this.clientDnsLookup = clientDnsLookup;
    }

    public Duration getReconnectBackoff() {
        return this.reconnectBackoff;
    }

    public void setReconnectBackoff(Duration reconnectBackoff) {
        this.reconnectBackoff = reconnectBackoff;
    }

    public Duration getReconnectBackoffMax() {
        return this.reconnectBackoffMax;
    }

    public void setReconnectBackoffMax(Duration reconnectBackoffMax) {
        this.reconnectBackoffMax = reconnectBackoffMax;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public Duration getRetryBackoff() {
        return this.retryBackoff;
    }

    public void setRetryBackoff(Duration retryBackoff) {
        this.retryBackoff = retryBackoff;
    }

    public Duration getConnectionMaxIdle() {
        return this.connectionMaxIdle;
    }

    public void setConnectionMaxIdle(Duration connectionMaxIdle) {
        this.connectionMaxIdle = connectionMaxIdle;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public Duration getMetadataMaxAge() {
        return this.metadataMaxAge;
    }

    public void setMetadataMaxAge(Duration metadataMaxAge) {
        this.metadataMaxAge = metadataMaxAge;
    }

    public Integer getSendBufferBytes() {
        return this.sendBufferBytes;
    }

    public void setSendBufferBytes(Integer sendBufferBytes) {
        this.sendBufferBytes = sendBufferBytes;
    }

    public Integer getReceiveBufferBytes() {
        return this.receiveBufferBytes;
    }

    public void setReceiveBufferBytes(Integer receiveBufferBytes) {
        this.receiveBufferBytes = receiveBufferBytes;
    }

    public List<Class<? extends MetricsReporter>> getMetricsReporters() {
        return this.metricsReporters;
    }

    public void setMetricsReporters(List<Class<? extends MetricsReporter>> metricsReporters) {
        this.metricsReporters = metricsReporters;
    }

    public Integer getMetricsSamples() {
        return this.metricsSamples;
    }

    public void setMetricsSamples(Integer metricsSamples) {
        this.metricsSamples = metricsSamples;
    }

    public Duration getMetricsSampleWindow() {
        return this.metricsSampleWindow;
    }

    public void setMetricsSampleWindow(Duration metricsSampleWindow) {
        this.metricsSampleWindow = metricsSampleWindow;
    }

    public Sensor.RecordingLevel getMetricsRecordingLevel() {
        return this.metricsRecordingLevel;
    }

    public void setMetricsRecordingLevel(Sensor.RecordingLevel metricsRecordingLevel) {
        this.metricsRecordingLevel = metricsRecordingLevel;
    }

    public SecurityFactory getSecurity() {
        return this.security;
    }

    public void setSecurity(SecurityFactory security) {
        this.security = security;
    }

    public Set<KafkaTopicFactory> getTopics() {
        return this.topics;
    }

    public Boolean getTopicCreationEnabled() {
        return this.topicCreationEnabled;
    }

    public void setTopicCreationEnabled(boolean topicCreationEnabled) {
        this.topicCreationEnabled = topicCreationEnabled;
    }

    protected AdminClient buildAdminClient(Map<String, Object> config) {
        return AdminClient.create(config);
    }

    protected void manageAdminClient(LifecycleEnvironment lifecycle, AdminClient adminClient) {
        List<Object> newTopics = Collections.emptyList();
        if (this.topicCreationEnabled) {
            newTopics = this.topics.stream().map(KafkaTopicFactory::asNewTopic).collect(Collectors.toList());
        }
        this.manageAdminClient(lifecycle, adminClient, newTopics);
    }

    protected void manageAdminClient(LifecycleEnvironment lifecycle, AdminClient adminClient, Collection<NewTopic> topics) {
        lifecycle.manage((Managed)new KafkaAdminClientManager(adminClient, this.name, topics));
    }

    protected void registerHealthCheck(HealthCheckRegistry healthChecks, AdminClient adminClient) {
        healthChecks.register(this.name, (HealthCheck)new KafkaAdminHealthCheck(adminClient, this.name));
    }

    public abstract AdminClient build(LifecycleEnvironment var1, HealthCheckRegistry var2, Map<String, Object> var3);

    public abstract AdminClient build(LifecycleEnvironment var1, HealthCheckRegistry var2, Map<String, Object> var3, Collection<NewTopic> var4);
}

