/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.kafka.security.SecurityFactory;
import io.dropwizard.kafka.tracing.TracingFactory;
import io.dropwizard.validation.ValidationMethod;
import java.util.Optional;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;

public abstract class KafkaClientFactory {
    @NotEmpty
    @JsonProperty
    protected String name;
    @Valid
    @JsonProperty
    protected Optional<SecurityFactory> security = Optional.empty();
    @JsonProperty
    protected boolean metricsEnabled = true;
    @JsonProperty
    protected boolean includeTaggedMetrics = false;
    @JsonProperty
    protected Set<String> bootstrapServers;
    @JsonProperty
    protected Optional<String> clientDNSLookup = Optional.empty();
    @JsonProperty
    protected Optional<String> clientId = Optional.empty();
    @Valid
    @JsonProperty
    private TracingFactory tracingFactory;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Optional<SecurityFactory> getSecurity() {
        return this.security;
    }

    public void setSecurity(Optional<SecurityFactory> security) {
        this.security = security;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public void setMetricsEnabled(boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
    }

    public boolean isIncludeTaggedMetrics() {
        return this.includeTaggedMetrics;
    }

    public void setIncludeTaggedMetrics(boolean includeTaggedMetrics) {
        this.includeTaggedMetrics = includeTaggedMetrics;
    }

    public Set<String> getBootstrapServers() {
        return this.bootstrapServers;
    }

    public Optional<String> getClientDNSLookup() {
        return this.clientDNSLookup;
    }

    public void setClientDNSLookup(Optional<String> clientDNSLookup) {
        this.clientDNSLookup = clientDNSLookup;
    }

    public Optional<String> getClientId() {
        return this.clientId;
    }

    public void setClientId(Optional<String> clientId) {
        this.clientId = clientId;
    }

    public void setBootstrapServers(Set<String> bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public TracingFactory getTracingFactory() {
        return this.tracingFactory;
    }

    public void setTracingFactory(TracingFactory tracingFactory) {
        this.tracingFactory = tracingFactory;
    }

    @ValidationMethod(message="Some Kafka configurations were invalid")
    @JsonIgnore
    public abstract boolean isValidConfiguration();
}

