/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka;

import brave.Tracing;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.kafka.KafkaConsumerFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;

public abstract class KafkaConsumerBundle<K, V, T extends Configuration>
implements ConfiguredBundle<T> {
    private final Collection<String> topics;
    private final ConsumerRebalanceListener consumerRebalanceListener;
    private final Map<String, Object> configOverrides;
    @Nullable
    private Consumer<K, V> consumer;

    protected KafkaConsumerBundle(Collection<String> topics, ConsumerRebalanceListener consumerRebalanceListener) {
        this(topics, consumerRebalanceListener, Collections.emptyMap());
    }

    protected KafkaConsumerBundle(Collection<String> topics, ConsumerRebalanceListener consumerRebalanceListener, Map<String, Object> configOverrides) {
        this.topics = Objects.requireNonNull(topics);
        this.consumerRebalanceListener = Objects.requireNonNull(consumerRebalanceListener);
        this.configOverrides = Objects.requireNonNull(configOverrides);
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) throws Exception {
        KafkaConsumerFactory<K, V> kafkaConsumerFactory = Objects.requireNonNull(this.getKafkaConsumerFactory(configuration));
        Tracing tracing = Tracing.current();
        this.consumer = kafkaConsumerFactory.build(environment.lifecycle(), environment.healthChecks(), tracing, this.consumerRebalanceListener, this.configOverrides);
    }

    public abstract KafkaConsumerFactory<K, V> getKafkaConsumerFactory(T var1);

    public Consumer<K, V> getConsumer() {
        return Objects.requireNonNull(this.consumer);
    }
}

