/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka;

import brave.Tracing;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.dropwizard.jackson.Discoverable;
import io.dropwizard.kafka.KafkaClientFactory;
import io.dropwizard.kafka.deserializer.DeserializerFactory;
import io.dropwizard.kafka.managed.KafkaConsumerManager;
import io.dropwizard.kafka.metrics.DropwizardMetricsReporter;
import io.dropwizard.kafka.security.SecurityFactory;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.util.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.KafkaConsumer;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public abstract class KafkaConsumerFactory<K, V>
extends KafkaClientFactory
implements Discoverable {
    @NotEmpty
    @JsonProperty
    protected String consumerGroupId;
    @Valid
    @NotNull
    @JsonProperty
    protected DeserializerFactory keyDeserializer;
    @Valid
    @NotNull
    @JsonProperty
    protected DeserializerFactory valueDeserializer;
    @JsonProperty
    protected boolean autoCommitEnabled = true;
    @JsonProperty
    protected Duration autoCommitInterval = Duration.seconds((long)5L);
    @Min(value=-1L)
    @JsonProperty
    protected @Min(value=-1L) int sendBufferBytes = -1;
    @Min(value=-1L)
    @JsonProperty
    protected @Min(value=-1L) int receiveBufferBytes = -1;
    @Min(value=1L)
    @JsonProperty
    protected @Min(value=1L) int maxPollRecords = 500;
    @NotNull
    @JsonProperty
    protected Duration maxPollInterval = Duration.minutes((long)5L);

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public void setConsumerGroupId(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
    }

    public DeserializerFactory getKeyDeserializer() {
        return this.keyDeserializer;
    }

    public void setKeyDeserializer(DeserializerFactory keyDeserializer) {
        this.keyDeserializer = keyDeserializer;
    }

    public DeserializerFactory getValueDeserializer() {
        return this.valueDeserializer;
    }

    public void setValueDeserializer(DeserializerFactory valueDeserializer) {
        this.valueDeserializer = valueDeserializer;
    }

    public boolean isAutoCommitEnabled() {
        return this.autoCommitEnabled;
    }

    public void setAutoCommitEnabled(boolean autoCommitEnabled) {
        this.autoCommitEnabled = autoCommitEnabled;
    }

    public Duration getAutoCommitInterval() {
        return this.autoCommitInterval;
    }

    public void setAutoCommitInterval(Duration autoCommitInterval) {
        this.autoCommitInterval = autoCommitInterval;
    }

    public int getSendBufferBytes() {
        return this.sendBufferBytes;
    }

    public void setSendBufferBytes(int sendBufferBytes) {
        this.sendBufferBytes = sendBufferBytes;
    }

    public int getReceiveBufferBytes() {
        return this.receiveBufferBytes;
    }

    public void setReceiveBufferBytes(int receiveBufferBytes) {
        this.receiveBufferBytes = receiveBufferBytes;
    }

    public int getMaxPollRecords() {
        return this.maxPollRecords;
    }

    public void setMaxPollRecords(int maxPollRecords) {
        this.maxPollRecords = maxPollRecords;
    }

    public Duration getMaxPollInterval() {
        return this.maxPollInterval;
    }

    public void setMaxPollInterval(Duration maxPollInterval) {
        this.maxPollInterval = maxPollInterval;
    }

    protected Map<String, Object> createBaseKafkaConfigurations() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.putAll(this.keyDeserializer.build(true));
        config.putAll(this.valueDeserializer.build(false));
        config.put("enable.auto.commit", this.autoCommitEnabled);
        if (this.autoCommitEnabled && this.autoCommitInterval != null) {
            config.put("auto.commit.interval.ms", (int)this.autoCommitInterval.toMilliseconds());
        }
        this.clientDNSLookup.ifPresent(clientIdValue -> config.put("client.dns.lookup", clientIdValue));
        this.clientId.ifPresent(clientIdValue -> config.put("client.id", clientIdValue));
        config.put("send.buffer.bytes", this.sendBufferBytes);
        config.put("receive.buffer.bytes", this.receiveBufferBytes);
        config.put("max.poll.records", this.maxPollRecords);
        config.put("max.poll.interval.ms", (int)this.maxPollInterval.toMilliseconds());
        this.security.filter(SecurityFactory::isEnabled).ifPresent(securityFactory -> config.putAll(securityFactory.build()));
        if (this.metricsEnabled) {
            config.put("io.dropwizard.kafka.metrics.includeTags", this.includeTaggedMetrics);
            config.put("metric.reporters", DropwizardMetricsReporter.class.getName());
            config.put("io.dropwizard.kafka.metrics.name", this.name);
        }
        return config;
    }

    protected Consumer<K, V> buildConsumer(Map<String, Object> config) {
        return new KafkaConsumer(config);
    }

    protected void registerHealthCheck(HealthCheckRegistry healthChecks, Consumer<K, V> consumer) {
    }

    protected void manageConsumer(LifecycleEnvironment lifecycle, Consumer<K, V> consumer) {
        lifecycle.manage((Managed)new KafkaConsumerManager(consumer));
    }

    public Consumer<K, V> build(LifecycleEnvironment lifecycle, HealthCheckRegistry healthChecks, @Nullable Tracing tracing, @Nullable ConsumerRebalanceListener rebalanceListener) {
        return this.build(lifecycle, healthChecks, tracing, rebalanceListener, Collections.emptyMap());
    }

    public abstract Consumer<K, V> build(LifecycleEnvironment var1, HealthCheckRegistry var2, @Nullable Tracing var3, @Nullable ConsumerRebalanceListener var4, Map<String, Object> var5);
}

