/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka;

import brave.Tracing;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.kafka.KafkaProducerFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.Producer;

public abstract class KafkaProducerBundle<K, V, T extends Configuration>
implements ConfiguredBundle<T> {
    private final Collection<String> topics;
    private final Map<String, Object> configOverrides;
    @Nullable
    private Producer<K, V> producer;

    public KafkaProducerBundle(Collection<String> topics) {
        this(topics, Collections.emptyMap());
    }

    public KafkaProducerBundle(Collection<String> topics, Map<String, Object> configOverrides) {
        this.topics = Objects.requireNonNull(topics);
        this.configOverrides = Objects.requireNonNull(configOverrides);
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) throws Exception {
        KafkaProducerFactory<K, V> kafkaProducerFactory = Objects.requireNonNull(this.getKafkaProducerFactory(configuration));
        Tracing tracing = Tracing.current();
        this.producer = kafkaProducerFactory.build(environment.lifecycle(), environment.healthChecks(), this.topics, tracing, this.configOverrides);
    }

    public abstract KafkaProducerFactory<K, V> getKafkaProducerFactory(T var1);

    public Producer<K, V> getProducer() {
        return Objects.requireNonNull(this.producer);
    }
}

