/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka;

import brave.Tracing;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.dropwizard.jackson.Discoverable;
import io.dropwizard.kafka.KafkaClientFactory;
import io.dropwizard.kafka.health.KafkaProducerHealthCheck;
import io.dropwizard.kafka.managed.KafkaProducerManager;
import io.dropwizard.kafka.metrics.DropwizardMetricsReporter;
import io.dropwizard.kafka.security.SecurityFactory;
import io.dropwizard.kafka.serializer.SerializerFactory;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDuration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.record.CompressionType;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public abstract class KafkaProducerFactory<K, V>
extends KafkaClientFactory
implements Discoverable {
    @Valid
    @NotNull
    @JsonProperty
    protected SerializerFactory keySerializer;
    @Valid
    @NotNull
    @JsonProperty
    protected SerializerFactory valueSerializer;
    @JsonProperty
    protected Optional<String> acks = Optional.empty();
    @JsonProperty
    protected Optional<String> retries = Optional.empty();
    @JsonProperty
    protected Optional<Integer> maxInFlightRequestsPerConnection = Optional.empty();
    @JsonProperty
    protected Optional<Duration> maxPollBlockTime = Optional.empty();
    @NotEmpty
    @JsonProperty
    protected String compressionType;
    @Min(value=-1L)
    @JsonProperty
    protected @Min(value=-1L) int sendBufferBytes;
    @Min(value=-1L)
    @JsonProperty
    protected @Min(value=-1L) int receiveBufferBytes;
    @Min(value=0L)
    @JsonProperty
    protected @Min(value=0L) long bufferMemory;
    @Min(value=0L)
    @JsonProperty
    protected @Min(value=0L) int batchSize;
    @MinDuration(value=0L)
    @JsonProperty
    protected @MinDuration(value=0L) Duration linger;
    @MinDuration(value=0L)
    @JsonProperty
    protected @MinDuration(value=0L) Duration requestTimeout;
    @JsonProperty
    protected boolean enableIdempotence;
    @JsonProperty
    protected Optional<String> transactionalId;

    public KafkaProducerFactory() {
        this.compressionType = CompressionType.GZIP.name;
        this.sendBufferBytes = -1;
        this.receiveBufferBytes = -1;
        this.bufferMemory = 0x2000000L;
        this.batchSize = 16384;
        this.linger = Duration.milliseconds((long)0L);
        this.requestTimeout = Duration.seconds((long)30L);
        this.enableIdempotence = false;
        this.transactionalId = Optional.empty();
    }

    public SerializerFactory getKeySerializer() {
        return this.keySerializer;
    }

    public void setKeySerializer(SerializerFactory keySerializer) {
        this.keySerializer = keySerializer;
    }

    public SerializerFactory getValueSerializer() {
        return this.valueSerializer;
    }

    public void setValueSerializer(SerializerFactory valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public Optional<String> getAcks() {
        return this.acks;
    }

    public void setAcks(Optional<String> acks) {
        this.acks = acks;
    }

    public Optional<String> getRetries() {
        return this.retries;
    }

    public void setRetries(Optional<String> retries) {
        this.retries = retries;
    }

    public Optional<Integer> getMaxInFlightRequestsPerConnection() {
        return this.maxInFlightRequestsPerConnection;
    }

    public void setMaxInFlightRequestsPerConnection(Optional<Integer> maxInFlightRequestsPerConnection) {
        this.maxInFlightRequestsPerConnection = maxInFlightRequestsPerConnection;
    }

    public Optional<Duration> getMaxPollBlockTime() {
        return this.maxPollBlockTime;
    }

    public void setMaxPollBlockTime(Optional<Duration> maxPollBlockTime) {
        this.maxPollBlockTime = maxPollBlockTime;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(String compressionType) {
        this.compressionType = compressionType;
    }

    public int getSendBufferBytes() {
        return this.sendBufferBytes;
    }

    public void setSendBufferBytes(int sendBufferBytes) {
        this.sendBufferBytes = sendBufferBytes;
    }

    public int getReceiveBufferBytes() {
        return this.receiveBufferBytes;
    }

    public void setReceiveBufferBytes(int receiveBufferBytes) {
        this.receiveBufferBytes = receiveBufferBytes;
    }

    public long getBufferMemory() {
        return this.bufferMemory;
    }

    public void setBufferMemory(long bufferMemory) {
        this.bufferMemory = bufferMemory;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public Duration getLinger() {
        return this.linger;
    }

    public void setLinger(Duration linger) {
        this.linger = linger;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public boolean isEnableIdempotence() {
        return this.enableIdempotence;
    }

    public void setEnableIdempotence(boolean enableIdempotence) {
        this.enableIdempotence = enableIdempotence;
    }

    public Optional<String> getTransactionalId() {
        return this.transactionalId;
    }

    public void setTransactionalId(Optional<String> transactionalId) {
        this.transactionalId = transactionalId;
    }

    protected Map<String, Object> createBaseKafkaConfigurations() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.putAll(this.keySerializer.build(true));
        config.putAll(this.valueSerializer.build(false));
        this.security.filter(SecurityFactory::isEnabled).ifPresent(securityFactory -> config.putAll(securityFactory.build()));
        this.acks.ifPresent(acksValue -> config.put("acks", acksValue));
        this.retries.ifPresent(retriesValue -> config.put("retries", retriesValue));
        this.maxInFlightRequestsPerConnection.ifPresent(maxInFlightRequestsPerConnectionValue -> config.put("max.in.flight.requests.per.connection", maxInFlightRequestsPerConnectionValue));
        this.maxPollBlockTime.ifPresent(maxPollBlockTimeValue -> config.put("max.block.ms", maxPollBlockTimeValue.toMilliseconds()));
        this.clientDNSLookup.ifPresent(clientIdValue -> config.put("client.dns.lookup", clientIdValue));
        this.clientId.ifPresent(clientIdValue -> config.put("client.id", clientIdValue));
        this.transactionalId.ifPresent(transactionalIdValue -> config.put("transactional.id", transactionalIdValue));
        config.put("compression.type", this.compressionType);
        config.put("send.buffer.bytes", this.sendBufferBytes);
        config.put("receive.buffer.bytes", this.receiveBufferBytes);
        config.put("buffer.memory", this.bufferMemory);
        config.put("batch.size", this.batchSize);
        config.put("enable.idempotence", this.enableIdempotence);
        config.put("linger.ms", (int)this.linger.toMilliseconds());
        config.put("request.timeout.ms", (int)this.requestTimeout.toMilliseconds());
        if (this.metricsEnabled) {
            config.put("io.dropwizard.kafka.metrics.includeTags", Boolean.toString(this.includeTaggedMetrics));
            config.put("metric.reporters", DropwizardMetricsReporter.class.getName());
            config.put("io.dropwizard.kafka.metrics.name", this.name);
        }
        return config;
    }

    protected void registerProducerHealthCheck(HealthCheckRegistry healthChecks, Producer<K, V> producer, Collection<String> topics) {
        healthChecks.register(this.name, (HealthCheck)new KafkaProducerHealthCheck(producer, topics));
    }

    protected Producer<K, V> buildProducer(Map<String, Object> config) {
        return new KafkaProducer(config);
    }

    protected void manageProducer(LifecycleEnvironment lifecycle, Producer<K, V> producer) {
        lifecycle.manage((Managed)new KafkaProducerManager(producer));
    }

    public Producer<K, V> build(LifecycleEnvironment lifecycle, HealthCheckRegistry healthChecks, Collection<String> topics, @Nullable Tracing tracing) {
        return this.build(lifecycle, healthChecks, topics, tracing, Collections.emptyMap());
    }

    public abstract Producer<K, V> build(LifecycleEnvironment var1, HealthCheckRegistry var2, Collection<String> var3, @Nullable Tracing var4, Map<String, Object> var5);
}

